/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableDefault;
import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;

public class HystrixRequestContext
implements Closeable {
    private static ThreadLocal<HystrixRequestContext> requestVariables = new ThreadLocal();
    ConcurrentHashMap<HystrixRequestVariableDefault<?>, HystrixRequestVariableDefault.LazyInitializer<?>> state = new ConcurrentHashMap();

    public static boolean isCurrentThreadInitialized() {
        HystrixRequestContext context = requestVariables.get();
        return context != null && context.state != null;
    }

    public static HystrixRequestContext getContextForCurrentThread() {
        HystrixRequestContext context = requestVariables.get();
        if (context != null && context.state != null) {
            return context;
        }
        return null;
    }

    public static void setContextOnCurrentThread(HystrixRequestContext state) {
        requestVariables.set(state);
    }

    public static HystrixRequestContext initializeContext() {
        HystrixRequestContext state = new HystrixRequestContext();
        requestVariables.set(state);
        return state;
    }

    private HystrixRequestContext() {
    }

    public void shutdown() {
        if (this.state != null) {
            for (HystrixRequestVariableDefault v : this.state.keySet()) {
                try {
                    HystrixRequestVariableDefault.remove(this, v);
                }
                catch (Throwable t) {
                    HystrixRequestVariableDefault.logger.error("Error in shutdown, will continue with shutdown of other variables", t);
                }
            }
            this.state = null;
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

