/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.codahalemetricspublisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.metric.consumer.CumulativeCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCommandLatencyDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingCommandMaxConcurrencyStream;
import com.netflix.hystrix.metric.consumer.RollingCommandUserLatencyDistributionStream;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;

public class HystrixCodaHaleMetricsPublisherCommand
implements HystrixMetricsPublisherCommand {
    private final String metricsRootNode;
    private final HystrixCommandKey key;
    private final HystrixCommandGroupKey commandGroupKey;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixCommandProperties properties;
    private final MetricRegistry metricRegistry;
    private final String metricGroup;
    private final String metricType;
    static final Logger logger = LoggerFactory.getLogger(HystrixCodaHaleMetricsPublisherCommand.class);

    public HystrixCodaHaleMetricsPublisherCommand(String metricsRootNode, HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties, MetricRegistry metricRegistry) {
        this.metricsRootNode = metricsRootNode;
        this.key = commandKey;
        this.commandGroupKey = commandGroupKey;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.properties = properties;
        this.metricRegistry = metricRegistry;
        this.metricGroup = commandGroupKey.name();
        this.metricType = this.key.name();
    }

    public void initialize() {
        this.metricRegistry.register(this.createMetricName("isCircuitBreakerOpen"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.circuitBreaker.isOpen();
            }
        });
        this.metricRegistry.register(this.createMetricName("currentTime"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return System.currentTimeMillis();
            }
        });
        this.safelyCreateCumulativeCountForEvent("countBadRequests", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.BAD_REQUEST;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countCollapsedRequests", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.COLLAPSED;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countEmit", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.EMIT;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countExceptionsThrown", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.EXCEPTION_THROWN;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countFailure", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FAILURE;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countFallbackEmit", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_EMIT;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countFallbackFailure", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_FAILURE;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countFallbackDisabled", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_DISABLED;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countFallbackMissing", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_MISSING;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countFallbackRejection", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_REJECTION;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countFallbackSuccess", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_SUCCESS;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countResponsesFromCache", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.RESPONSE_FROM_CACHE;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countSemaphoreRejected", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.SEMAPHORE_REJECTED;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countShortCircuited", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.SHORT_CIRCUITED;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countSuccess", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.SUCCESS;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countThreadPoolRejected", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.THREAD_POOL_REJECTED;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countTimeout", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.TIMEOUT;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountBadRequests", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.BAD_REQUEST;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountCollapsedRequests", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.COLLAPSED;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountEmit", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.EMIT;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountExceptionsThrown", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.EXCEPTION_THROWN;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountFailure", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FAILURE;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountFallbackEmit", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_EMIT;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountFallbackFailure", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_FAILURE;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountFallbackDisabled", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_DISABLED;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountFallbackMissing", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_MISSING;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountFallbackRejection", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_REJECTION;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountFallbackSuccess", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.FALLBACK_SUCCESS;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountResponsesFromCache", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.RESPONSE_FROM_CACHE;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountSemaphoreRejected", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.SEMAPHORE_REJECTED;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountShortCircuited", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.SHORT_CIRCUITED;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountSuccess", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.SUCCESS;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountThreadPoolRejected", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.THREAD_POOL_REJECTED;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountTimeout", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.TIMEOUT;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingMaxConcurrentExecutionCount", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.COMMAND_MAX_ACTIVE;
            }
        });
        this.metricRegistry.register(this.createMetricName("executionSemaphorePermitsInUse"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getCurrentConcurrentExecutionCount();
            }
        });
        this.metricRegistry.register(this.createMetricName("errorPercentage"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getHealthCounts().getErrorPercentage();
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_mean"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimeMean();
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_5"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(5.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_25"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(25.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_50"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(50.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_75"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(75.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_90"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(90.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_99"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_995"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.5);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_mean"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimeMean();
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_5"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(5.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_25"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(25.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_50"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(50.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_75"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(75.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_90"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(90.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_99"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_995"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.5);
            }
        });
        this.metricRegistry.register(this.createMetricName("commandGroup"), (Metric)new Gauge<String>(){

            public String getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.commandGroupKey != null ? HystrixCodaHaleMetricsPublisherCommand.this.commandGroupKey.name() : null;
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_rollingStatisticalWindowInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerRequestVolumeThreshold"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerRequestVolumeThreshold().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerSleepWindowInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerSleepWindowInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerErrorThresholdPercentage"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerErrorThresholdPercentage().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerForceOpen"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerForceOpen().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerForceClosed"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerForceClosed().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_executionIsolationThreadTimeoutInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_executionTimeoutInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_executionIsolationStrategy"), (Metric)new Gauge<String>(){

            public String getValue() {
                return ((HystrixCommandProperties.ExecutionIsolationStrategy)HystrixCodaHaleMetricsPublisherCommand.this.properties.executionIsolationStrategy().get()).name();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_metricsRollingPercentileEnabled"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.metricsRollingPercentileEnabled().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_requestCacheEnabled"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.requestCacheEnabled().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_requestLogEnabled"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.requestLogEnabled().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.executionIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        RollingCommandEventCounterStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        CumulativeCommandEventCounterStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingCommandLatencyDistributionStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingCommandUserLatencyDistributionStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingCommandMaxConcurrencyStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
    }

    protected String createMetricName(String name) {
        return MetricRegistry.name((String)this.metricsRootNode, (String[])new String[]{this.metricGroup, this.metricType, name});
    }

    protected void createCumulativeCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getCumulativeCount(event);
            }
        });
    }

    protected void safelyCreateCumulativeCountForEvent(final String name, final Func0<HystrixRollingNumberEvent> eventThunk) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                try {
                    return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getCumulativeCount((HystrixRollingNumberEvent)eventThunk.call());
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing CodaHale metrics, error looking up eventType for : {}.  Please check that all Hystrix versions are the same!", (Object)name);
                    return 0L;
                }
            }
        });
    }

    protected void createRollingCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getRollingCount(event);
            }
        });
    }

    protected void safelyCreateRollingCountForEvent(final String name, final Func0<HystrixRollingNumberEvent> eventThunk) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                try {
                    return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getRollingCount((HystrixRollingNumberEvent)eventThunk.call());
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing CodaHale metrics, error looking up eventType for : {}.  Please check that all Hystrix versions are the same!", (Object)name);
                    return 0L;
                }
            }
        });
    }
}

