/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.codahalemetricspublisher;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.netflix.config.DynamicPropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableCodaHaleMetricFilter
implements MetricFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableCodaHaleMetricFilter.class);
    private DynamicPropertyFactory archaiusPropertyFactory;

    public ConfigurableCodaHaleMetricFilter(DynamicPropertyFactory archaiusPropertyFactory) {
        this.archaiusPropertyFactory = archaiusPropertyFactory;
    }

    public boolean matches(String s, Metric metric) {
        if (!this.isFilterEnabled()) {
            return true;
        }
        boolean matchesFilter = this.archaiusPropertyFactory.getBooleanProperty(s, false).get();
        LOGGER.debug("Does metric [{}] match filter? [{}]", (Object)s, (Object)matchesFilter);
        return matchesFilter;
    }

    protected boolean isFilterEnabled() {
        boolean filterEnabled = this.archaiusPropertyFactory.getBooleanProperty("filter.graphite.metrics", false).get();
        LOGGER.debug("Is filter enabled? [{}]", (Object)filterEnabled);
        return filterEnabled;
    }
}

