/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.codahalemetricspublisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixCodaHaleMetricsPublisherThreadPool
implements HystrixMetricsPublisherThreadPool {
    private final String metricsRootNode;
    private final HystrixThreadPoolKey key;
    private final HystrixThreadPoolMetrics metrics;
    private final HystrixThreadPoolProperties properties;
    private final MetricRegistry metricRegistry;
    private final String metricGroup;
    private final String metricType;
    private List<String> metricsList = new ArrayList<String>();
    static final Logger logger = LoggerFactory.getLogger(HystrixCodaHaleMetricsPublisherThreadPool.class);

    public HystrixCodaHaleMetricsPublisherThreadPool(String metricsRootNode, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties, MetricRegistry metricRegistry) {
        this.metricsRootNode = metricsRootNode;
        this.key = threadPoolKey;
        this.metrics = metrics;
        this.properties = properties;
        this.metricRegistry = metricRegistry;
        this.metricGroup = "HystrixThreadPool";
        this.metricType = this.key.name();
    }

    public void initialize() {
        this.metricRegistry.register(this.createMetricName("name"), (Metric)new Gauge<String>(){

            public String getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.key.name();
            }
        });
        this.metricRegistry.register(this.createMetricName("currentTime"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return System.currentTimeMillis();
            }
        });
        this.metricRegistry.register(this.createMetricName("threadActiveCount"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentActiveCount();
            }
        });
        this.metricRegistry.register(this.createMetricName("completedTaskCount"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentCompletedTaskCount();
            }
        });
        this.metricRegistry.register(this.createMetricName("largestPoolSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentLargestPoolSize();
            }
        });
        this.metricRegistry.register(this.createMetricName("totalTaskCount"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentTaskCount();
            }
        });
        this.metricRegistry.register(this.createMetricName("queueSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentQueueSize();
            }
        });
        this.metricRegistry.register(this.createMetricName("rollingMaxActiveThreads"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getRollingMaxActiveThreads();
            }
        });
        this.metricRegistry.register(this.createMetricName("countThreadsExecuted"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCumulativeCountThreadsExecuted();
            }
        });
        this.metricRegistry.register(this.createMetricName("rollingCountCommandsRejected"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                try {
                    return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED);
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing CodaHale metrics, error looking up eventType for : rollingCountCommandsRejected.  Please check that all Hystrix versions are the same!");
                    return 0L;
                }
            }
        });
        this.metricRegistry.register(this.createMetricName("rollingCountThreadsExecuted"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getRollingCountThreadsExecuted();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_corePoolSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.coreSize().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_maximumSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.maximumSize().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_actualMaximumSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.properties.actualMaximumSize();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_keepAliveTimeInMinutes"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.keepAliveTimeMinutes().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_queueSizeRejectionThreshold"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.queueSizeRejectionThreshold().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_maxQueueSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.maxQueueSize().get();
            }
        });
    }

    public void tearDown() {
        this.metricsList.forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
    }

    protected String createMetricName(String name) {
        String metricName = MetricRegistry.name((String)this.metricsRootNode, (String[])new String[]{this.metricGroup, this.metricType, name});
        this.metricsList.add(metricName);
        return metricName;
    }
}

