(ns hypercrud-ui.widget
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-ui.form :refer [cj-form]]
            [hypercrud-ui.input :refer [input*]]
            [hypercrud-ui.multi-select :refer [multi-select* multi-select-markup]]
            [hypercrud-ui.select :refer [select*]]))


(defn input [fieldinfo client model value change! transact!]
  [input* {:type "text"
           :value value
           :on-change change!}])


(defn select [{:keys [options] :as fieldinfo} client model value change! transact!]
  ;;select* has parameterized markup fn todo
  [select* client model options value change! transact!])


(defn select-comp [fieldinfo client model value change! transact!]
  (cj-form client value model transact!))


(defn multi-select [fieldinfo client model value change! transact!]
  (multi-select*
    multi-select-markup
    fieldinfo client model value change! #(change! [:db/add nil]) transact!)) ;add-item! is: add nil to set


(defn multi-select-comp [{:keys [options] :as fieldinfo} client model value change! transact!]
  [multi-select*
   multi-select-markup
   fieldinfo client model value change! #(change! [:db/add :temp-tempid]) transact!]) ;add new entity to set


(defn keyword-input [fieldinfo client model value change! transact!]
  [input* {:type "text"
           :value (str value)
           :on-change #(change! [:db/add (keyword (subs % 1))])}])


(defn default [fieldinfo client model value change! transact!]
  [input* {:type "text"
           :value (str (select-keys fieldinfo [:datatype :set :component]))
           :read-only true}])
