(ns hypercrud-ui.widget
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-ui.form :refer [cj-form]]
            [hypercrud-ui.input :refer [input*]]
            [hypercrud-ui.multi-select :refer [multi-select* multi-select-markup]]
            [hypercrud-ui.select :refer [select*]]
            [hypercrud-client.core :as hypercrud]))


(defn input [fieldinfo _ value change! transact!]
  [input* {:class ""
           :type "text"
           :value value
           :on-change change!}])


(defn input-many [fieldinfo _ value change! transact!]
  [input* {:type "text"
           :value (clojure.string/join ", " value)}])


(defn select [{:keys [options] :as fieldinfo} client value change! transact!]
  [hypercrud/resolve-query client (:rel options)
   (fn [cj-options-list]
     [select* {:client client
               :label-prop (:label-prop options)
               :cj-options-list cj-options-list
               :value value
               :change! change!
               :transact! transact!}])])

(defn select-comp [fieldinfo client value change! transact!]
  [hypercrud/resolve client value #(cj-form client (:rel %) (:template %) transact!)])


(defn multi-select [fieldinfo client value change! transact!]
  (multi-select*
    multi-select-markup
    fieldinfo client value change! #(change! nil :db/add) transact!)) ;add-item! is: add nil to set


(defn multi-select-comp [{:keys [options] :as fieldinfo} client value change! transact!]
  [hypercrud/resolve-query client (:rel options)
   (fn [hc-node]
     [multi-select*
      multi-select-markup
      fieldinfo client value change! #(change! :temp-tempid :db/add) transact!])]) ;add new entity to set


(defn keyword-input [fieldinfo _ value change! transact!]
  [input* {:type "text"
           :value (str value)
           :on-change #(change! (keyword (subs % 1)) :db/add)}])


(defn default [fieldinfo _ value change! transact!]
  [input* {:type "text"
           :value (str (select-keys fieldinfo [:datatype :set]))}])
