(ns hypercrud-ui.form
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-client.core :as hypercrud]))


(defn cj-form-field [{:keys [datatype name prompt] :as fieldinfo} client value change! transact!]
  [:div.cj-field {:key (str name)}
   [:label prompt]
   (auto-control fieldinfo client value change! transact!)])


(defn cj-form [client eid template transact!]
  [hypercrud/resolve client eid
   (fn [hc-node]
     [:div.cj-form
      (doall
        (map (fn [{:keys [name] :as fieldinfo}]
               (let [value (get-in hc-node [:data name])
                     change! #(transact! client [[%2 eid name %1]])]
                 (cj-form-field fieldinfo client value change! transact!)))
             (:data template)))])])
