(ns hypercrud-ui.select
  (:require [hypercrud-client.core :as hypercrud]
            [hypercrud-ui.form :as form]
            [reagent.core :as reagent]
            [hypercrud-client.util :as util]
            [cljs.pprint :as pprint]))


(defn select-option
  ":option :value and :on-change is a string, since that's how the dom works"
  [client label-prop eid]
  ^{:key [eid (hypercrud/tx client)]}
  [hypercrud/resolve client eid
   (fn [hc-node]
     ;; the dom will stringify the :value i believe
     [:option {:key eid :value (util/transit-encode eid)}
      (name (get (:data hc-node) label-prop))])
   (fn [hc-node] [:option])])


(defn select*
  [{:keys [client label-prop cj-options-list value change!] :as props}]
  (let [updating? (reagent/atom false)]
    (fn [{:keys [client label-prop cj-options-list value change!] :as props}]
      [hypercrud/resolve-query client (:rel cj-options-list)
       (fn [{:keys [data template] :as cj-options-list}]
         (let [props (-> props
                         (dissoc :client :label-prop :cj-options-list :value :change!)

                         ;; normalize value for the dom
                         ;; value is either nil, an :ident (keyword), or
                         ;; a cj item ref e.g. {:href ...}
                         (assoc :value (util/transit-encode
                                         (cond
                                           (nil? value) nil
                                           (util/tempid? value) "create-new"
                                           :else value)))

                         ;; reconstruct the typed value (keyword or cj item ref)
                         (assoc :on-change
                                #(do
                                  (let [select-value (util/transit-decode (.-target.value %))
                                        eid (cond
                                              (nil? select-value) nil
                                              (= "create-new" select-value) (hypercrud/tempid client (:typetag template))
                                              :else-hc-select-option-node select-value)]
                                    (change! eid :db/add)
                                    ;; and also add our new guy to the option list (for all combos)
                                    (reset! updating? false)))))

               create-new? (some-> value util/tempid?)
               show-form? (or @updating? create-new?)]

           ^{:key (:href cj-options-list)}
           [:div.editable-select
            [:button {:on-click #(swap! updating? not)
                      :disabled (= nil value)}
             (if show-form? "Discard" "Edit")]
            [:span
             [:select props (-> (doall (map (fn [eid]
                                              (select-option client label-prop eid))
                                            data))
                                (concat [[:option {:key :create-new :value (util/transit-encode "create-new")} "Create New"]
                                         [:option {:key :blank :value (util/transit-encode nil)} "--"]]))]]
            (if show-form?
              #_ [hypercrud/resolve client value
               (fn [hc-node]
                 [:pre (with-out-str (pprint/pprint hc-node))])]
              [form/cj-form client value template]
              )]))])))
