(ns hypercrud-ui.widget
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-ui.form :refer [cj-form]]
            [hypercrud-ui.input :refer [input*]]
            [hypercrud-ui.multi-select :refer [multi-select* multi-select-markup]]
            [hypercrud-ui.select :refer [select*]]
            [hypercrud-client.core :as hypercrud]))


(defn input [fieldinfo _ value change!]
  [input* {:class ""
           :type "text"
           :value value
           :on-change change!}])


(defn input-many [fieldinfo _ value change!]
  [input* {:type "text"
           :value (clojure.string/join ", " value)}])


(defn select [{:keys [options] :as fieldinfo} client value change!]
  [hypercrud/resolve client (:rel options)
   (fn [cj-options-list]
     [select* {:client client
               :label-prop (:label-prop options)
               :cj-options-list cj-options-list
               :value value
               :change change!}])])

(defn select-comp [fieldinfo client value change!]
  [hypercrud/resolve client value #(cj-form client % (:template %))])


(defn multi-select [fieldinfo client value change!]
  (multi-select*
    multi-select-markup
    fieldinfo client value change! (change! nil :db/add))) ;add-item! is: add nil to set


(defn multi-select-comp [{:keys [options] :as fieldinfo} client value change!]
  [hypercrud/resolve client (:rel options)
   (fn [{:keys [template]}]
     (multi-select*
       multi-select-markup
       fieldinfo client value change! (change! :temp-tempid :db/add)))]) ;add new entity to set


(defn keyword-input [fieldinfo _ value change!]
  [input* {:type "text"
           :value (str value)
           :on-change #(change! (keyword (subs % 1)) :db/add)}])


(defn default [fieldinfo _ value change!]
  [input* {:type "text"
           :value (str (select-keys fieldinfo [:datatype :set]))}])
