(ns hypercrud-ui.multi-select
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-client.core :as hypercrud]))


(defmulti multi-select-markup (fn [click-add! control-tuples] :default))


(defn multi-select* [markupfn fieldinfo client value change! add-item!] {:pre [(not (nil? value))]}
  (let [control-tuples (map (fn [{:keys [rel] :as hc-node}]
                              [rel
                               (change! rel :db/retract)
                               [auto-control (assoc fieldinfo :set false) client
                                hc-node
                                #(hypercrud/transact! client [[rel (:name fieldinfo) % %2]])]])
                            value)]
    (markupfn add-item! control-tuples)))


(defmethod multi-select-markup :default [click-add! control-tuples & [css-class]]
  [:div.multi-select {:class css-class}
   (map (fn [[rel click-remove! control]]
          ^{:key rel}
          [:div.multi-select-group
           [:button {:on-click click-remove!} "-"]
           control])
        control-tuples)
   [:button {:on-click click-add!} "+"]])
