(ns hypercrud-ui.widget
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-ui.form :refer [cj-form]]
            [hypercrud-ui.input :refer [input*]]
            [hypercrud-ui.multi-select :refer [multi-select* multi-select-markup]]
            [hypercrud-ui.select :refer [select*]]
            [hypercrud-client.core :as hypercrud]))


(defn input [fieldinfo _ field-cur]
  [input* {:class ""
           :type "text"
           :value @field-cur
           :on-change #(reset! field-cur %)}])


(defn input-many [fieldinfo _ field-cur]
  [input* {:type "text"
           :value (clojure.string/join ", " @field-cur)
           :on-change #(into #{} (clojure.string/split % #"\s*\,\s*"))}])


(defn select [{:keys [options] :as fieldinfo} client field-cur]
  (assert (not (nil? field-cur)))
  [hypercrud/resolve client options
   (fn [cj-options-list]
     (assert (not (nil? field-cur)))
     [select* {:client client
               :label-prop (:label-prop options)
               :cj-options-list cj-options-list
               :cur field-cur}])])

(defn select-comp [fieldinfo client field-cur]
  [hypercrud/resolve client @field-cur #(cj-form client field-cur % (:template %))])


(defn multi-select [fieldinfo client field-cur]
  (multi-select*
    multi-select-markup
    fieldinfo client field-cur (fn [old]
                                 (assoc old (count old) nil))))


(defn multi-select-comp [{:keys [options] :as fieldinfo} client field-cur]
  [hypercrud/resolve client options
   (fn [{:keys [template]}]
     (multi-select*
       multi-select-markup
       fieldinfo client field-cur (fn [old]
                                    (assoc old (count old) (hypercrud/new client template)))))])


(defn keyword-input [fieldinfo _ field-cur]
  [input* {:type "text" :value (str @field-cur) :on-change #(reset! field-cur %)}])


(defn default [fieldinfo _ field-cur]
  [input* {:type "text" :value (str (select-keys fieldinfo [:datatype :set]))}])
