(ns hypercrud-ui.multi-select
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [cursor.core :as cursor]))


(defn set-cur->vec-cur [cur]
  (cursor/virtual-cursor (into [] @cur)
                         (fn [f]
                           (swap! cur (fn [aset]
                                        (into #{} (f (into [] aset))))))
                         cur))


(defn drop-nth
  "We're using vector types here so we can refine (random access)"
  [coll i]
  (vec (concat (subvec coll 0 i)
               (subvec coll (inc i)))))


(defmulti multi-select-markup (fn [click-add! control-tuples] :default))


(defn multi-select* [fieldinfo client field-cur add-item!] {:pre [(not (nil? field-cur))]}
  (let [field-cur (set-cur->vec-cur field-cur)
        control-tuples (map-indexed (fn [i {:keys [rel]}]
                                      [rel
                                       i
                                       (fn [e] (swap! field-cur #(drop-nth % i)))
                                       [auto-control (assoc fieldinfo :set false) client (field-cur [i])]])
                                    @field-cur)]
    (multi-select-markup #(swap! field-cur add-item!) control-tuples)))



(defmethod multi-select-markup :default [click-add! control-tuples]
  [:div.multi-select
   (map (fn [[rel i click-remove! control]]
          ^{:key i}
          [:div.multi-select-group
           [:button {:on-click click-remove!} "-"]
           control])
        control-tuples)
   [:button {:on-click click-add!} "+"]])
