(ns hypercrud-ui.form
  (:require [hypercrud-ui.auto-control :refer [auto-control]]))


(defn cj-form-field [{:keys [datatype name prompt] :as fieldinfo} client field-cur]
  {:pre [(not (nil? field-cur))]}
  [:div.cj-field {:key (str name)}
   [:label prompt]
   (auto-control fieldinfo client field-cur)])


(defn cj-form [client form-cur hc-node template & [css-class]]
  [:div.cj-form {:class css-class}
   (doall
     (map (fn [{:keys [name] :as fieldinfo}]
            (cj-form-field fieldinfo client (form-cur [:data name] (get-in hc-node [:data name]))))
          (:data template)))])
