(ns hypercrud-ui.widget
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-ui.input :refer [input*]]
            [hypercrud-ui.select :refer [select*]]
            [hypercrud-client.core :as hypercrud]
            [cursor.core :as cursor]))


(defn input [fieldinfo _ field-cur]
  [input* {:class ""
          :type "text"
          :value @field-cur
          :on-change #(reset! field-cur %)}])


(defn input-many [fieldinfo _ field-cur]
  [input* {:type "text"
          :value (clojure.string/join ", " @field-cur)
          :on-change #(into #{} (clojure.string/split % #"\s*\,\s*"))}])


(defn select [{:keys [options] :as fieldinfo} client field-cur]
  (assert (not (nil? field-cur)))
  [hypercrud/resolve client options
   (fn [cj-options-list]
     (assert (not (nil? field-cur)))
     [select* {:client client
              :label-prop (:label-prop options)
              :cj-options-list cj-options-list
              :cur field-cur}])])


(defn multi-select [{:keys [options] :as fieldinfo} client field-cur]
  (assert (not (nil? field-cur)))
  [hypercrud/resolve client options
   (fn [cj-options-list]
     (assert (not (nil? field-cur)))
     (let [as-vec-cur (cursor/virtual-cursor (into [] @field-cur)
                                             (fn [f]
                                               (swap! field-cur (fn [aset]
                                                                  (into #{} (f (into [] aset))))))
                                             field-cur)]
       [:div.multi-select
        (map-indexed (fn [i {:keys [rel]}]
                       ^{:key i}
                       [:div.multi-select-group
                        [:button {:on-click #(swap! as-vec-cur (fn [coll]
                                                                 (vec (concat (subvec coll 0 i)
                                                                              (subvec coll (inc i))))))}
                         "-"]
                        [auto-control (assoc fieldinfo :set false) client (as-vec-cur [i])]])
                     @as-vec-cur)
        [:button {:on-click #(swap! as-vec-cur (fn [old]
                                                 (assoc old (count old) nil)))}
         "+"]]))])


(defn keyword-input [fieldinfo _ field-cur]
  [input* {:type "text" :value (str @field-cur) :on-change #(reset! field-cur %)}])


(defn default [fieldinfo _ field-cur]
  [input* {:type "text" :value (str (select-keys fieldinfo [:datatype :set]))}])
