(ns hypercrud-ui.auto-control-impls
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-ui.input :refer [input]]
            [hypercrud-ui.select :refer [select-multiple select]]
            [hypercrud-client.core :as hypercrud]
            [cursor.core :as cursor]))


(defmethod auto-control {:datatype :string :set false}
  [fieldinfo _ field-cur]
  [input {:class ""
          :type "text"
          :value @field-cur
          :on-change #(reset! field-cur %)}])


(defmethod auto-control {:datatype :string :set true} [fieldinfo _ field-cur]
  [input {:type "text"
          :value (clojure.string/join ", " @field-cur)
          :on-change #(into #{} (clojure.string/split % #"\s*\,\s*"))}])


(defmethod auto-control {:datatype :ref :set false}
  [{:keys [options] :as fieldinfo} client field-cur]
  (assert (not (nil? field-cur)))
  [hypercrud/resolve client options
   (fn [cj-options-list]
     (assert (not (nil? field-cur)))
     [select {:client client
              :label-prop (:label-prop options)
              :cj-options-list cj-options-list
              :cur field-cur}])])


(defmethod auto-control {:datatype :ref :set true}
  [{:keys [options] :as fieldinfo} client field-cur]
  (assert (not (nil? field-cur)))
  [hypercrud/resolve client options
   (fn [cj-options-list]
     (assert (not (nil? field-cur)))
     (let [as-vec-cur (cursor/virtual-cursor (into [] @field-cur)
                                             (fn [f]
                                               (swap! field-cur (fn [aset]
                                                                  (into #{} (f (into [] aset))))))
                                             field-cur)]
       [:div
        (map-indexed (fn [i {:keys [rel]}]
                       ^{:key i}
                       [auto-control (assoc fieldinfo :set false) client (as-vec-cur [i])])
                     @as-vec-cur)
        [:button {:on-click #(swap! as-vec-cur (fn [old]
                                                 (assoc old (count old) nil)))}
         "+"]]))])


(defmethod auto-control {:datatype :keyword :set false}
  [fieldinfo _ field-cur]
  [input {:type "text" :value (str @field-cur) :on-change #(reset! field-cur %)}])


(defmethod auto-control :default
  [fieldinfo _ field-cur]
  [input {:type "text" :value (str (select-keys fieldinfo [:datatype :set]))}])
