(ns hypercrud-ui.collection
  (:require [cljs-hash.md5 :refer [md5]]
            [hypercrud-client.core :as hypercrud]
            [hypercrud-ui.table-cell :refer [render-table-cell]]))


(defn cj-table-thead
  "Build table column headers, the cj-item may not be resolved"
  [template]
  (let [cols (map
               (fn [{:keys [datatype name prompt] :as fieldinfo}]
                 [:td {:key name} prompt])
               (:data template))
        select-col [:td {:key "select-col"}]
        all-cols (conj cols select-col)]
    [:thead
     [:tr all-cols]]))


(defn cj-table-tr
  "Build a table row for the cj-item, the cj-item may not be resolved"
  [client template collection-rel {:keys [href links data rel] :as cj-item}]
  (assert (not (nil? cj-item)))
  (let [cols (map (fn [{:keys [datatype name prompt] :as fieldinfo}]
                    [:td.truncate {:key name}
                     [render-table-cell (some-> data (get name))
                      fieldinfo
                      ;; the nav path uses the :name, :name doesn't
                      ;; match the lazy-cj-item's :rel in this case
                      {:client client}]])
                  (:data template))]
    [:tr {:key href}
     [:td {:key "update-td"}
      [:a {:href (str (name collection-rel) "/" (name rel))}
       "Update"]]
     cols]))


;; :select :single or :select :multiple
;; the selection value is either the :href, or a set of :href
;; for now hardcode to single-select
;; Widgets can't take cursors directly, as there may be more complicated
;; state transitions desired.
(defn cj-grid [{:keys [version href links data queries template] :as cj-collection}
               client]
  [:table.u-full-width
   [:colgroup [:col {:span "1" :style {:width "20px"}}]]
   (cj-table-thead template)

   [:tbody
    (map (fn [[rel cj-item]]
           ;; use the href as the radio name - hack
           ^{:key (:href cj-item)}
           [hypercrud/resolve client cj-item
            #(cj-table-tr client template (:rel cj-collection) %)
            (fn [hc-node] [:tr])])
         data)
    [:tr {:key "create-td"}
     [:td
      [:a {:href (str (name (:rel cj-collection)) "/" (hypercrud/tempid client))}
       "Create"]]]]])