(ns hypercrud-ui.collection
  (:require [cljs-hash.md5 :refer [md5]]
            [hypercrud-client.core :as hypercrud]
            [hypercrud-ui.table-cell :refer [render-table-cell]]))


(defn cj-table-thead
  "Build table column headers, the cj-item may not be resolved"
  [template sel-value sel-on-change]
  (let [cols (map
              (fn [{:keys [datatype name prompt] :as fieldinfo}]
                [:td {:key name} prompt])
              (:data template))
        select-col [:td {:key "select-col"}
                    (if (not (= sel-value ""))
                      [:a {:href "javascript:void(0)"       ;should be a button
                           :on-click #(do (.preventDefault %) (sel-on-change ""))}
                       "clear"])]
        all-cols (conj cols select-col)]
    [:thead
     [:tr all-cols]]))


(defn cj-table-tr
  "Build a table row for the cj-item, the cj-item may not be resolved"
  [client template sel-value sel-on-change name {:keys [href links data] :as cj-item}]
  (assert (not (nil? cj-item)))
  (let [cols (map (fn [{:keys [datatype name prompt] :as fieldinfo}]
                    [:td.truncate {:key name}
                     (render-table-cell (some-> data (get name))
                                        fieldinfo
                                        ;; the nav path uses the :name, :name doesn't
                                        ;; match the lazy-cj-item's :rel in this case
                                        {:client client})])
                  (:data template))
        select-col [:td {:key "select-col"}
                    [:input {:type "radio"
                             :checked (= sel-value href)
                             :on-change #(sel-on-change href)
                             :name name}]]
        all-cols (conj cols select-col)]
    [:tr {:key href} all-cols]))



(defn hash-obj [o]
  (md5 (.stringify js/JSON (clj->js o))))


;; :select :single or :select :multiple
;; the selection value is either the :href, or a set of :href
;; for now hardcode to single-select
;; Widgets can't take cursors directly, as there may be more complicated
;; state transitions desired.
(defn cj-grid [{:keys [version href links data queries template] :as cj-collection}
               {:keys [client value on-change] :as props}]
  [:table.u-full-width
    [:colgroup [:col {:span "1" :style {:width "20px"}}]]
    (cj-table-thead template value on-change)

    [:tbody
      (map (fn [[rel cj-item]]
             ;; use the href as the radio name - hack
             ^{:key (:href cj-item)}
             [hypercrud/resolve client cj-item
               #(cj-table-tr client template value on-change href %)
               (fn [hc-node] [:tr])])
           (take 10 data))]])
