(ns hypercrud-ui.table-cell
  (:require [hypercrud-client.core :as hypercrud]))

(defprotocol TableCell
  (render-table-cell [val fieldinfo props]))

(extend-type default
  TableCell
  (render-table-cell [val _ _]
    [:code {:key (pr-str val)} (pr-str val)]))

(extend-type string
  TableCell
  (render-table-cell [val _ _]
    val))

(extend-type cljs.core.Keyword
  TableCell
  (render-table-cell [val _ _]
    (name val)))

(extend-type cljs.core.PersistentHashSet
  TableCell
  (render-table-cell [val fieldinfo props]
    (let [rendered-set-items (map #(render-table-cell % fieldinfo props) val)]
      (interpose ", " rendered-set-items))))


;; A map always corresponds to :datatype :ref
;; all :ref types have :options in the template (of the parent item,
;; not of the combo value)
;; use the :options :label-field to render
(extend-type cljs.core.PersistentArrayMap ;; a special lazy-cj-item type here might help
  TableCell
  (render-table-cell [{:keys [href] :as cj-item}
                      {{:keys [label-prop] :as options} :options :as fieldinfo}
                      {:keys [client navigate!] :as props}]
    (assert (not (nil? label-prop)))

    ^{:key href}
    ;; Href is the same as the value. We key off value for the recursive set case,
    ;; for symmetry with key off value in primitive-in-set cases
    [hypercrud/resolve client cj-item
     (fn [{:keys [links data template rel]}]
       [:a {:href (str "/" (name (:rel options)) "/" (name rel))}
        (render-table-cell (get data label-prop)
                           (:data template)
                           props)])]))
