(ns hypercrud.service.representation
  (:require [hypercrud.service.response :as response])
  (:import (hypercrud.service.response EntityResponse QueryResponse TransactResponse IndexResponse)))


;; Nice to render out vectors for the client since they are already associative and any
;; benefits of list e.g. lazy are lost due to serialization on the wire


(extend-type EntityResponse
  response/HypercrudRepresentation
  (represent [{:keys [entity form]}]
    (->> form                                               ; drive logic by the hypermedia form, not the entity
         (map (fn [{:keys [name datatype set]}]
                (let [v (get entity name)
                      v (cond

                          (and (= datatype :ref) (not set) (not (nil? v)))
                          (:db/id v)

                          (and (= datatype :ref) set (not (nil? v)))
                          (into #{} (map :db/id v))

                          :not-a-ref
                          v)]
                  [name v])))
         (into (select-keys entity [:meta/type])))))


(defn represent-ref-val [v]
  v
  #_(if (keyword? v) v (:db/id v)))

(extend-type QueryResponse
  response/HypercrudRepresentation
  (represent [{:keys [resultset]}]
    (mapv represent-ref-val resultset)))


(extend-type TransactResponse
  response/HypercrudRepresentation
  (represent [{:keys [tx]}]
    {:tx tx}))


(extend-type IndexResponse
  response/HypercrudRepresentation
  (represent [{:keys [tx]}]
    {:tx tx}))