(ns hypercrud-service.core
  (:require [io.pedestal.http.body-params :as body-params]
            [hypercrud-service.pedestal-util :as pedestal-util]
            [hypercrud-service.root-renderer :as root-renderer]
            [hypercrud-service.rest.routes :as routes]))



(defn route [root endpoints]
  (let [routes (map (fn [[k {:keys [query-fn typetag]}]]
                      (routes/mk-inner-routes k query-fn typetag))
                    endpoints)]
    `[~root {:get [:index-get (routes/mk-index-get :index-get ~endpoints)]}
      ^:interceptors [~(body-params/body-params)
                      pedestal-util/auto-content-type
                      pedestal-util/combine-body-params
                      pedestal-util/save-body-val
                      pedestal-util/wrap-ring-response
                      root-renderer/wrap-hypercrud]
      ~@routes]))

