(ns hypercrud-service.rest.index
  (:require [hypercrud-service.pedestal-util :as pedestal-util]))


(defn link-index [endpoints tx]
  (->> (mapv (fn [[k {:keys [query-fn typetag doc]}]]
               (let [rel (keyword k)]
                 [rel {:doc doc
                       :rel rel
                       :href (pedestal-util/url-for (keyword k) :params {:tx tx})}]))
             endpoints)
       (into {})))