(ns hypercrud-service.root-renderer
  (:require [io.pedestal.interceptor :as interceptor]
            [hypercrud-service.response :as response]
            [hypercrud-service.cache :as cache]))


(interceptor/defafter wrap-hypercrud
  "wrap the response value (a collection or entity with hypermedia hints) into a
hypercrud representation. Happens in an interceptor so that we can resolve urls from the jvm
directly to the underlying HypercrudResponse record, not to the final representation."
  [context]
  (let [prod? (get-in context [:request :params :prod])
        accept (get-in context [:request :headers "accept"])
        real-request? (not (= accept "application/vnd.datomic.entity+edn"))
        cache? (and prod? real-request?)]
    (if real-request?
      (update-in context [:response] (fn [r]
                                       {:hypercrud (response/represent r)
                                        :cache (if cache?
                                                 (cache/mk-hc-cache (response/represent r))
                                                 nil)}))
      context)))
