(ns mcp-tasks.story-prompts
  "Built-in story prompt templates.

  Story prompts are used for story-based workflow management. Each prompt is
  defined as a def var with a docstring and content that includes frontmatter
  metadata."
  (:require
    [clojure.java.io :as io]))

(def create-story-tasks
  "Break down a story into categorized, executable tasks."
  (slurp (io/resource "prompts/create-story-tasks.md")))

(def execute-story-child
  "Execute the next task from a story's task list."
  (slurp (io/resource "prompts/execute-story-child.md")))

(def review-story-implementation
  "Review the implementation of a story."
  (slurp (io/resource "prompts/review-story-implementation.md")))

(def complete-story
  "Mark a story as complete and archive it."
  (slurp (io/resource "prompts/complete-story.md")))

(def create-story-pr
  "Create a pull request for a completed story."
  (slurp (io/resource "prompts/create-story-pr.md")))

(def execute-task
  "Execute a task following category-specific workflow instructions."
  (slurp (io/resource "prompts/execute-task.md")))

(def refine-task
  "Refine a task to improve clarity and completeness."
  (slurp (io/resource "prompts/refine-task.md")))
