/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.graylog2.GelfMessage;
import org.graylog2.GelfSender;

public class GelfHandler
extends Handler {
    private static final int MAX_SHORT_MESSAGE_LENGTH = 250;
    private String graylogHost;
    private String originHost;
    private int graylogPort;
    private String facility;
    private GelfSender gelfSender;
    private boolean extractStacktrace;
    private Map<String, String> fields;

    public GelfHandler() {
        String property;
        LogManager manager = LogManager.getLogManager();
        String prefix = this.getClass().getName();
        this.graylogHost = manager.getProperty(prefix + ".graylogHost");
        String port = manager.getProperty(prefix + ".graylogPort");
        this.graylogPort = null == port ? 12201 : Integer.parseInt(port);
        this.extractStacktrace = "true".equalsIgnoreCase(manager.getProperty(prefix + ".extractStacktrace"));
        int fieldNumber = 0;
        this.fields = new HashMap<String, String>();
        while (null != (property = manager.getProperty(prefix + ".additionalField." + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                this.fields.put(property.substring(0, index), property.substring(index + 1));
            }
            ++fieldNumber;
        }
        this.facility = manager.getProperty(prefix + ".facility");
        String level = manager.getProperty(prefix + ".level");
        if (null != level) {
            this.setLevel(Level.parse(level.trim()));
        } else {
            this.setLevel(Level.INFO);
        }
        String filter = manager.getProperty(prefix + ".filter");
        try {
            if (null != filter) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(filter);
                this.setFilter((Filter)clazz.newInstance());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public synchronized void flush() {
    }

    private String getOriginHost() {
        if (null == this.originHost) {
            this.originHost = this.getLocalHostName();
        }
        return this.originHost;
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            this.reportError("Unknown local hostname", uhe, 0);
            return null;
        }
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (null == this.gelfSender) {
            try {
                this.gelfSender = new GelfSender(this.graylogHost, this.graylogPort);
            }
            catch (UnknownHostException e) {
                this.reportError("Unknown Graylog2 hostname:" + this.graylogHost, e, 1);
            }
            catch (SocketException e) {
                this.reportError("Socket exception", e, 1);
            }
        }
        if (null == this.gelfSender || !this.gelfSender.sendMessage(this.makeMessage(record))) {
            this.reportError("Could not send GELF message", null, 1);
        }
    }

    public void close() {
        if (null != this.gelfSender) {
            this.gelfSender.close();
            this.gelfSender = null;
        }
    }

    private GelfMessage makeMessage(LogRecord record) {
        Throwable thrown;
        String message = record.getMessage();
        String shortMessage = message.length() > 250 ? message.substring(0, 249) : message;
        if (this.extractStacktrace && null != (thrown = record.getThrown())) {
            StringWriter sw = new StringWriter();
            thrown.printStackTrace(new PrintWriter(sw));
            message = message + "\n\r" + sw.toString();
        }
        GelfMessage gelfMessage = new GelfMessage(shortMessage, message, new Date(record.getMillis()), String.valueOf(this.levelToSyslogLevel(record.getLevel())));
        gelfMessage.addField("SourceClassName", record.getSourceClassName());
        gelfMessage.addField("SourceMethodName", record.getSourceMethodName());
        if (null != this.getOriginHost()) {
            gelfMessage.setHost(this.getOriginHost());
        }
        if (null != this.facility) {
            gelfMessage.setFacility(this.facility);
        }
        if (null != this.fields) {
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                gelfMessage.addField(entry.getKey(), entry.getValue());
            }
        }
        return gelfMessage;
    }

    private int levelToSyslogLevel(Level level) {
        int syslogLevel = level == Level.SEVERE ? 3 : (level == Level.WARNING ? 4 : (level == Level.INFO ? 6 : 7));
        return syslogLevel;
    }
}

