/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.log;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.graylog2.GelfMessage;
import org.graylog2.GelfMessageFactory;
import org.graylog2.GelfMessageProvider;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GelfConsoleAppender
extends ConsoleAppender
implements GelfMessageProvider {
    private static String originHost;
    private boolean extractStacktrace;
    private boolean addExtendedInformation;
    private Map<String, String> fields;

    public GelfConsoleAppender() {
    }

    public GelfConsoleAppender(Layout layout) {
        super(layout);
    }

    public GelfConsoleAppender(Layout layout, String target) {
        super(layout, target);
    }

    public void setAdditionalFields(String additionalFields) {
        this.fields = (Map)JSONValue.parse((String)additionalFields.replaceAll("'", "\""));
    }

    @Override
    public boolean isExtractStacktrace() {
        return this.extractStacktrace;
    }

    public void setExtractStacktrace(boolean extractStacktrace) {
        this.extractStacktrace = extractStacktrace;
    }

    @Override
    public boolean isAddExtendedInformation() {
        return this.addExtendedInformation;
    }

    public void setAddExtendedInformation(boolean addExtendedInformation) {
        this.addExtendedInformation = addExtendedInformation;
    }

    @Override
    public String getOriginHost() {
        return originHost;
    }

    public void setOriginHost(String originHost) {
        GelfConsoleAppender.originHost = originHost;
    }

    @Override
    public String getFacility() {
        return null;
    }

    @Override
    public Map<String, String> getFields() {
        if (this.fields == null) {
            this.fields = new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.fields);
    }

    protected void subAppend(LoggingEvent event) {
        GelfMessage gelf = GelfMessageFactory.makeMessage(event, this);
        this.qw.write(gelf.toJson());
        this.qw.write(Layout.LINE_SEP);
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }
}

