/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.log;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.graylog2.GelfMessage;
import org.graylog2.GelfMessageFactory;
import org.graylog2.GelfMessageProvider;
import org.graylog2.GelfSender;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GelfAppender
extends AppenderSkeleton
implements GelfMessageProvider {
    private String graylogHost;
    private static String originHost;
    private int graylogPort = 12201;
    private String facility;
    private GelfSender gelfSender;
    private boolean extractStacktrace;
    private boolean addExtendedInformation;
    private Map<String, String> fields;

    public void setAdditionalFields(String additionalFields) {
        this.fields = (Map)JSONValue.parse((String)additionalFields.replaceAll("'", "\""));
    }

    public int getGraylogPort() {
        return this.graylogPort;
    }

    public void setGraylogPort(int graylogPort) {
        this.graylogPort = graylogPort;
    }

    public String getGraylogHost() {
        return this.graylogHost;
    }

    public void setGraylogHost(String graylogHost) {
        this.graylogHost = graylogHost;
    }

    @Override
    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    @Override
    public boolean isExtractStacktrace() {
        return this.extractStacktrace;
    }

    public void setExtractStacktrace(boolean extractStacktrace) {
        this.extractStacktrace = extractStacktrace;
    }

    @Override
    public String getOriginHost() {
        if (originHost == null) {
            originHost = this.getLocalHostName();
        }
        return originHost;
    }

    private String getLocalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.errorHandler.error("Unknown local hostname", (Exception)e, 0);
        }
        return hostName;
    }

    public void setOriginHost(String originHost) {
        GelfAppender.originHost = originHost;
    }

    @Override
    public boolean isAddExtendedInformation() {
        return this.addExtendedInformation;
    }

    public void setAddExtendedInformation(boolean addExtendedInformation) {
        this.addExtendedInformation = addExtendedInformation;
    }

    @Override
    public Map<String, String> getFields() {
        if (this.fields == null) {
            this.fields = new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.fields);
    }

    public void activateOptions() {
        try {
            this.gelfSender = new GelfSender(this.graylogHost, this.graylogPort);
        }
        catch (UnknownHostException e) {
            this.errorHandler.error("Unknown Graylog2 hostname:" + this.getGraylogHost(), (Exception)e, 1);
        }
        catch (SocketException e) {
            this.errorHandler.error("Socket exception", (Exception)e, 1);
        }
    }

    protected void append(LoggingEvent event) {
        GelfMessage gelfMessage = GelfMessageFactory.makeMessage(event, this);
        if (this.getGelfSender() == null || !this.getGelfSender().sendMessage(gelfMessage)) {
            this.errorHandler.error("Could not send GELF message");
        }
    }

    public GelfSender getGelfSender() {
        return this.gelfSender;
    }

    public void close() {
        this.getGelfSender().close();
    }

    public boolean requiresLayout() {
        return false;
    }
}

