/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GelfMessage {
    private static final String ID_NAME = "id";
    private static final String GELF_VERSION = "1.0";
    private static final byte[] GELF_CHUNKED_ID = new byte[]{30, 15};
    private static final int MAXIMUM_CHUNK_SIZE = 1420;
    private String version = "1.0";
    private String host;
    private byte[] hostBytes = this.lastFourAsciiBytes("none");
    private String shortMessage;
    private String fullMessage;
    private Long timestamp;
    private long javaTimestamp;
    private String level;
    private String facility = "gelf-java";
    private String line;
    private String file;
    private Map<String, Object> additonalFields = new HashMap<String, Object>();

    public GelfMessage() {
    }

    public GelfMessage(String shortMessage, String fullMessage, Date timestamp, String level) {
        this.shortMessage = shortMessage;
        this.fullMessage = fullMessage;
        this.javaTimestamp = timestamp.getTime();
        this.timestamp = this.javaTimestamp / 1000L;
        this.level = level;
    }

    public GelfMessage(String shortMessage, String fullMessage, Long timestamp, String level, String line, String file) {
        this.shortMessage = shortMessage;
        this.fullMessage = fullMessage;
        this.javaTimestamp = timestamp;
        this.timestamp = this.javaTimestamp / 1000L;
        this.level = level;
        this.line = line;
        this.file = file;
    }

    public String toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", this.getVersion());
        map.put("host", this.getHost());
        map.put("short_message", this.getShortMessage());
        map.put("full_message", this.getFullMessage());
        map.put("timestamp", this.getTimestamp().intValue());
        map.put("level", this.getLevel());
        map.put("facility", this.getFacility());
        if (null != this.getFile()) {
            map.put("file", this.getFile());
        }
        if (null != this.getLine()) {
            map.put("line", this.getLine());
        }
        for (Map.Entry<String, Object> additionalField : this.additonalFields.entrySet()) {
            if (ID_NAME.equals(additionalField.getKey())) continue;
            map.put("_" + additionalField.getKey(), additionalField.getValue());
        }
        return JSONValue.toJSONString(map);
    }

    public List<byte[]> toDatagrams() {
        byte[] messageBytes = this.gzipMessage(this.toJson());
        ArrayList<byte[]> datagrams = new ArrayList<byte[]>();
        if (messageBytes.length > 1420) {
            this.sliceDatagrams(messageBytes, datagrams);
        } else {
            datagrams.add(messageBytes);
        }
        return datagrams;
    }

    private void sliceDatagrams(byte[] messageBytes, List<byte[]> datagrams) {
        int messageLength = messageBytes.length;
        byte[] messageId = ByteBuffer.allocate(8).putInt((int)System.currentTimeMillis()).put(this.hostBytes).array();
        int num = Double.valueOf(Math.ceil((double)messageLength / 1420.0)).intValue();
        for (int idx = 0; idx < num; ++idx) {
            byte[] header = this.concatByteArray(GELF_CHUNKED_ID, this.concatByteArray(messageId, new byte[]{(byte)idx, (byte)num}));
            int from = idx * 1420;
            int to = from + 1420;
            if (to >= messageLength) {
                to = messageLength;
            }
            byte[] datagram = this.concatByteArray(header, Arrays.copyOfRange(messageBytes, from, to));
            datagrams.add(datagram);
        }
    }

    private byte[] gzipMessage(String message) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream stream = new GZIPOutputStream(bos);
            stream.write(message.getBytes());
            stream.finish();
            stream.close();
            byte[] zipped = bos.toByteArray();
            bos.close();
            return zipped;
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] lastFourAsciiBytes(String host) {
        String shortHost = host.length() >= 4 ? host.substring(host.length() - 4) : host;
        try {
            return shortHost.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM without ascii support?", e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.hostBytes = this.lastFourAsciiBytes(host);
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public void setShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Long getJavaTimestamp() {
        return this.javaTimestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public GelfMessage addField(String key, String value) {
        this.getAdditonalFields().put(key, value);
        return this;
    }

    public GelfMessage addField(String key, Object value) {
        this.getAdditonalFields().put(key, value);
        return this;
    }

    public Map<String, Object> getAdditonalFields() {
        return this.additonalFields;
    }

    public void setAdditonalFields(Map<String, Object> additonalFields) {
        this.additonalFields = additonalFields;
    }

    public boolean isValid() {
        return !this.isEmpty(this.version) && !this.isEmpty(this.host) && !this.isEmpty(this.shortMessage) && !this.isEmpty(this.facility);
    }

    public boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    private byte[] concatByteArray(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

