/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.api.API;
import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentStack;
import clojure.lang.ISeq;
import clojure.lang.PersistentVector;
import clojure.lang.RT;

public class GershwinStack
implements IPersistentStack {
    private IPersistentStack stack = PersistentVector.EMPTY;
    private static IFn CLOJURE_CONJ = API.var((Object)"clojure.core", (Object)"conj");
    private static IFn CLOJURE_POP = API.var((Object)"clojure.core", (Object)"pop");
    private static String STACK_UNDERFLOW_MSG = "Data stack underflow. Can't take something off an empty data stack.";

    public IPersistentStack conj(Object form) {
        return (IPersistentStack)CLOJURE_CONJ.invoke(this.stack, form);
    }

    public IPersistentStack conjMutable(Object form) {
        this.stack = (IPersistentStack)CLOJURE_CONJ.invoke(this.stack, form);
        return this.stack;
    }

    public IPersistentStack conjIt(Object form) {
        if (form == null || !form.equals(RT.STACK_VOID)) {
            this.stack = (IPersistentStack)CLOJURE_CONJ.invoke(this.stack, form);
        }
        return this.stack;
    }

    public Object peekSafe() {
        if (this.stack.count() == 0) {
            throw new StackUnderflowException(STACK_UNDERFLOW_MSG);
        }
        return this.stack.peek();
    }

    public Object peek() {
        return this.stack.peek();
    }

    public IPersistentStack pop() {
        try {
            return this.stack.pop();
        }
        catch (IllegalStateException e) {
            throw new StackUnderflowException(STACK_UNDERFLOW_MSG, e);
        }
    }

    public IPersistentStack popMutable() {
        try {
            this.stack = this.stack.pop();
            return this.stack;
        }
        catch (IllegalStateException e) {
            throw new StackUnderflowException(STACK_UNDERFLOW_MSG);
        }
    }

    public Object popIt() {
        Object item = this.stack.peek();
        this.popMutable();
        return item;
    }

    public IPersistentStack clear() {
        this.stack = PersistentVector.EMPTY;
        return this.stack;
    }

    public IPersistentCollection empty() {
        return this.stack.empty();
    }

    public int count() {
        return this.stack.count();
    }

    public ISeq seq() {
        return this.stack.seq();
    }

    public IPersistentStack getStack() {
        return this.stack;
    }

    public IPersistentCollection cons(Object o) {
        return this.stack.cons(o);
    }

    public boolean equiv(Object o) {
        return this.stack.equiv(o);
    }

    public static class StackUnderflowException
    extends IllegalStateException {
        public StackUnderflowException() {
        }

        public StackUnderflowException(String message) {
            super(message);
        }

        public StackUnderflowException(String message, Throwable e) {
            super(message, e);
        }
    }
}

