/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.rocksdb.util.Environment;

public class RocksDB
extends RocksObject {
    public static final int NOT_FOUND = -1;
    private static final String[] compressionLibs_ = new String[]{"snappy", "zlib", "bzip2", "lz4", "lz4hc"};
    protected Filter filter_;

    public static synchronized void loadLibrary() {
        for (String string : compressionLibs_) {
            try {
                System.loadLibrary(string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        System.loadLibrary("rocksdbjni");
    }

    public static synchronized void loadLibrary(List<String> list) {
        block4: for (String string : compressionLibs_) {
            for (String string2 : list) {
                try {
                    System.load(string2 + "/" + Environment.getSharedLibraryName(string));
                    continue block4;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                }
            }
        }
        boolean bl = false;
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        for (String string : list) {
            try {
                System.load(string + "/" + Environment.getJniLibraryName("rocksdbjni"));
                bl = true;
                break;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                unsatisfiedLinkError = unsatisfiedLinkError2;
            }
        }
        if (!bl) {
            throw unsatisfiedLinkError;
        }
    }

    public static RocksDB open(String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB();
        Options options = new Options();
        rocksDB.open(options.nativeHandle_, options.cacheSize_, string);
        rocksDB.transferCppRawPointersOwnershipFrom(options);
        options.dispose();
        return rocksDB;
    }

    public static RocksDB open(Options options, String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB();
        rocksDB.open(options.nativeHandle_, options.cacheSize_, string);
        rocksDB.transferCppRawPointersOwnershipFrom(options);
        return rocksDB;
    }

    @Override
    public synchronized void dispose() {
        if (this.isInitialized()) {
            this.dispose(this.nativeHandle_);
            this.nativeHandle_ = 0L;
        }
    }

    public void close() {
        this.dispose();
    }

    public void put(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void put(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public void write(WriteOptions writeOptions, WriteBatch writeBatch) throws RocksDBException {
        this.write(writeOptions.nativeHandle_, writeBatch.nativeHandle_);
    }

    public int get(byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public int get(ReadOptions readOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length, byArray2, byArray2.length);
    }

    public byte[] get(byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, byArray.length);
    }

    public byte[] get(ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, byArray.length);
    }

    public Map<byte[], byte[]> multiGet(List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        List<byte[]> list2 = this.multiGet(this.nativeHandle_, list, list.size());
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) == null) continue;
            hashMap.put(list.get(i), list2.get(i));
        }
        return hashMap;
    }

    public Map<byte[], byte[]> multiGet(ReadOptions readOptions, List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        List<byte[]> list2 = this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, list, list.size());
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) == null) continue;
            hashMap.put(list.get(i), list2.get(i));
        }
        return hashMap;
    }

    public void remove(byte[] byArray) throws RocksDBException {
        this.remove(this.nativeHandle_, byArray, byArray.length);
    }

    public void remove(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.remove(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length);
    }

    public RocksIterator newIterator() {
        return new RocksIterator(this.iterator0(this.nativeHandle_));
    }

    @Override
    protected void finalize() {
        this.close();
    }

    protected RocksDB() {
    }

    protected void transferCppRawPointersOwnershipFrom(Options options) {
        this.filter_ = options.filter_;
        options.filter_ = null;
    }

    protected native void open(long var1, long var3, String var5) throws RocksDBException;

    protected native void put(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    protected native void put(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8) throws RocksDBException;

    protected native void write(long var1, long var3) throws RocksDBException;

    protected native int get(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    protected native int get(long var1, long var3, byte[] var5, int var6, byte[] var7, int var8) throws RocksDBException;

    protected native List<byte[]> multiGet(long var1, List<byte[]> var3, int var4);

    protected native List<byte[]> multiGet(long var1, long var3, List<byte[]> var5, int var6);

    protected native byte[] get(long var1, byte[] var3, int var4) throws RocksDBException;

    protected native byte[] get(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    protected native void remove(long var1, byte[] var3, int var4) throws RocksDBException;

    protected native void remove(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    protected native long iterator0(long var1);

    protected native void dispose(long var1);
}

