/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.awt;

import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGEvolveInputData;
import flatgui.core.FGEvolveResultData;
import flatgui.core.IFGContainer;
import flatgui.core.awt.AbstractHostComponent;
import flatgui.core.util.Tuple;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HostComponent
extends AbstractHostComponent {
    private static final Var extractCursor_ = RT.var((String)"flatgui.responsefeed", (String)"extract-cursor");
    private static final Var getDataForClipboard_ = RT.var((String)"flatgui.responsefeed", (String)"get-data-for-clipboard");
    private IFGContainer fgContainer_;
    private Function<FGEvolveInputData, Future<FGEvolveResultData>> feedFn_;
    Future<FGEvolveResultData> changedPathsFuture_;

    public void initialize(IFGContainer iFGContainer) {
        this.fgContainer_ = iFGContainer;
    }

    public ActionListener getEventFedCallback() {
        return actionEvent -> this.repaint();
    }

    public void setInputEventConsumer(Function<FGEvolveInputData, Future<FGEvolveResultData>> function) {
        this.feedFn_ = function;
    }

    @Override
    protected void changeCursorIfNeeded() throws Exception {
        FGEvolveResultData fGEvolveResultData = this.changedPathsFuture_.get();
        Set<Object> set = fGEvolveResultData.getEvolveReasonToTargetPath().keySet();
        if (!set.isEmpty() && set.stream().anyMatch(object -> object instanceof MouseEvent)) {
            Collection<List<Keyword>> collection = fGEvolveResultData.getEvolveReasonToTargetPath().values();
            Map<Object, Map<Keyword, Object>> map = this.fgContainer_.getFGModule().getComponentIdPathToComponent(collection);
            Keyword keyword = HostComponent.resolveCursor(map, this.fgContainer_);
            Integer n = keyword != null ? (Integer)FG_TO_AWT_CUSROR_MAP.get(keyword) : null;
            this.setCursor(n != null ? Cursor.getPredefinedCursor(n) : Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    protected void paintAll(Graphics graphics, double d, double d2, double d3, double d4) throws Exception {
        Future<List> future = this.fgContainer_.submitTask(() -> this.fgContainer_.getFGModule().getPaintAllSequence(d, d2, d3, d4));
        List list = future.get();
        this.paintSequence(graphics, list);
    }

    public static Keyword resolveCursor(Map<Object, Map<Keyword, Object>> map, IFGContainer iFGContainer) {
        Map<List, Keyword> map2 = map.entrySet().stream().map(entry -> Tuple.pair(entry.getKey(), extractCursor_.invoke(entry.getValue()))).filter(tuple -> tuple.getSecond() != null).collect(Collectors.toMap(tuple -> (List)tuple.getFirst(), tuple -> (Keyword)tuple.getSecond()));
        if (map2.isEmpty()) {
            return null;
        }
        Keyword keyword = map2.get(iFGContainer.getLastMouseTargetIdPath());
        if (keyword == null) {
            keyword = map2.values().stream().findAny().orElse(null);
        }
        return keyword;
    }

    public static String getTextForClipboard(IFGContainer iFGContainer) {
        Object object = getDataForClipboard_.invoke(iFGContainer.getFGModule().getContainer());
        return object != null ? object.toString() : null;
    }

    @Override
    protected void acceptEvolveReason(Object object) {
        this.changedPathsFuture_ = this.feedFn_.apply(new FGEvolveInputData(object, false));
    }

    private int paintSequence(Graphics graphics, Iterable<Object> iterable) {
        int n = 0;
        for (Object object : iterable) {
            if (object instanceof List) {
                this.getPrimitivePainter().paintPrimitive(graphics, (List)object);
                ++n;
                continue;
            }
            if (object == null) continue;
            System.out.println("Error: not a list: " + iterable);
        }
        return n;
    }
}

