/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class GrowControlArrayList<T>
extends AbstractList<T>
implements RandomAccess {
    private final GrowFunction growFn_;
    private int size_;
    private T[] data_;

    public GrowControlArrayList(int n, GrowFunction growFunction) {
        this.data_ = new Object[n];
        this.size_ = 0;
        this.growFn_ = growFunction;
    }

    public GrowControlArrayList(List<T> list, GrowFunction growFunction) {
        this.growFn_ = growFunction;
        int n = this.size_ = list.size();
        this.data_ = new Object[n];
        if (list instanceof GrowControlArrayList) {
            System.arraycopy(((GrowControlArrayList)list).data_, 0, this.data_, 0, this.size_);
        } else {
            for (int i = 0; i < this.size_; ++i) {
                this.data_[i] = list.get(i);
            }
        }
    }

    @Override
    public T get(int n) {
        return this.data_[n];
    }

    @Override
    public int size() {
        return this.size_;
    }

    @Override
    public T set(int n, T t) {
        T t2 = this.get(n);
        this.data_[n] = t;
        return t2;
    }

    @Override
    public boolean add(T t) {
        this.ensureCapacity(this.size_ + 1);
        this.data_[this.size_] = t;
        ++this.size_;
        return true;
    }

    @Override
    public void clear() {
        this.size_ = 0;
    }

    public final void ensureCapacity(int n) {
        if (n > this.getCapacity()) {
            int n2 = this.growFn_.apply(this.getCapacity(), n - this.getCapacity());
            this.changeCapacity(n2);
        }
    }

    public void trimCapacity() {
        if (this.getCapacity() > this.size_) {
            this.changeCapacity(this.size_);
        }
    }

    private void changeCapacity(int n) {
        Object[] objectArray = (Object[])Array.newInstance(this.data_.getClass().getComponentType(), n);
        System.arraycopy(this.data_, 0, objectArray, 0, this.size_);
        this.data_ = objectArray;
    }

    int getCapacity() {
        return this.data_.length;
    }

    public static class DefaultGrowControl
    implements GrowFunction {
        @Override
        public int apply(int n, int n2) {
            int n3 = Math.max(n >> 1, n2);
            return n + n3;
        }
    }

    public static interface GrowFunction {
        public int apply(int var1, int var2);
    }
}

