/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.IFGInteropUtil;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class FGWebInteropUtil
implements IFGInteropUtil {
    private static final Var strToFont_ = RT.var((String)"flatgui.awt", (String)"str->font");
    private static final Container CONTAINER = new Container();
    private final double unitSizePx_;
    private Font referenceFont_;
    private String referenceFontStr_;
    private Map<String, byte[]> fontStrToCharMetrics_;
    private FontMetrics referenceFontMetrics_;

    public FGWebInteropUtil(int n) {
        this.unitSizePx_ = n;
        this.referenceFontStr_ = FGWebInteropUtil.getDefaultFontStr();
        this.referenceFont_ = FGWebInteropUtil.getDefaultFont();
        this.fontStrToCharMetrics_ = new HashMap<String, byte[]>();
        this.updateFontMetrics();
    }

    @Override
    public double getStringWidth(String string, String string2) {
        if (string2 != null && !string2.equals(this.referenceFontStr_)) {
            this.setReferenceFont(string2, (Font)strToFont_.invoke((Object)string2));
        }
        if (string != null) {
            double d;
            byte[] byArray = this.fontStrToCharMetrics_.get(this.referenceFontStr_);
            if (byArray != null) {
                d = 0.0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) < ' ') continue;
                    d += (double)byArray[string.charAt(i) - 32];
                }
            } else {
                d = SwingUtilities.computeStringWidth(this.referenceFontMetrics_, string);
            }
            return d / this.unitSizePx_;
        }
        return 0.0;
    }

    @Override
    public double getFontHeight(String string) {
        double d = this.referenceFontMetrics_.getHeight();
        return d / this.unitSizePx_;
    }

    @Override
    public double getFontAscent(String string) {
        double d = this.referenceFontMetrics_.getAscent();
        return d / this.unitSizePx_;
    }

    public String setMetricsTransmission(byte[] byArray) {
        int n = byArray[1];
        int n2 = byArray.length - 1 - 1 - n;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 2, byArray2, 0, n);
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray2[i];
        }
        String string = String.valueOf(cArray);
        System.out.println("Received metrics for font " + string);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 2 + n, byArray3, 0, n2);
        this.fontStrToCharMetrics_.put(string, byArray3);
        return string;
    }

    @Override
    public void setReferenceFont(String string, Font font) {
        this.referenceFontStr_ = string;
        this.referenceFont_ = font;
        this.updateFontMetrics();
    }

    @Override
    public String getReferenceFontStr() {
        return this.referenceFontStr_;
    }

    public double getUnitSizePx() {
        return this.unitSizePx_;
    }

    private void updateFontMetrics() {
        this.referenceFontMetrics_ = FGWebInteropUtil.getDefaultReferenceFontMetrics(this.referenceFont_);
    }

    private static Font getDefaultFont() {
        return (Font)strToFont_.invoke((Object)FGWebInteropUtil.getDefaultFontStr());
    }

    public static String getDefaultFontStr() {
        return "12px Tahoma";
    }

    private static FontMetrics getDefaultReferenceFontMetrics(Font font) {
        return CONTAINER.getFontMetrics(font);
    }
}

