/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGEvolveInputData;
import flatgui.core.FGEvolveResultData;
import flatgui.core.FGHostStateEvent;
import flatgui.core.FGWebContainerWrapper;
import flatgui.core.IFGContainer;
import flatgui.core.IFGEvolveConsumer;
import flatgui.core.IFGInteropUtil;
import flatgui.core.IFGModule;
import flatgui.core.IFGTemplate;
import flatgui.core.engine.remote.FGLegacyCoreGlue;
import flatgui.core.engine.ui.FGRemoteAppContainer;
import flatgui.core.websocket.FGAppServer;
import flatgui.core.websocket.FGContainerSession;
import flatgui.core.websocket.FGContainerSessionHolder;
import flatgui.core.websocket.FGInputEventDecoder;
import flatgui.core.websocket.FGPredictor;
import flatgui.core.websocket.FGWebInteropUtil;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public class FGContainerWebSocket
implements WebSocketListener {
    private static final long SEND_PREDICTIONS_THRESHOLD = 500L;
    private static final Keyword fontKey_ = Keyword.intern((String)"font");
    private static final Keyword childrenKey_ = Keyword.intern((String)"children");
    private static final int METRICS_INPUT_CODE = 407;
    private static final int PING_INPUT_CODE = 408;
    private final FGContainerSessionHolder sessionHolder_;
    private final IFGTemplate template_;
    private final Consumer<IFGContainer> containerConsumer_;
    private final Consumer<FGRemoteAppContainer> instanceConsumer_;
    private final BiConsumer<Object, IFGContainer> sessionCloseConsumer_;
    private ExecutorService endpointTransportService_;
    private final FGPredictor predictor_;
    private volatile Session session_;
    private volatile FGWebContainerWrapper container_;
    private volatile FGInputEventDecoder parser_;
    private volatile FGContainerSession fgSession_;
    private volatile Timer blinkHelperTimer_;
    private volatile long latestInputEventTimestamp_;
    private volatile boolean predictionsSent_;
    private long totalInboundMessages_ = 0L;
    private double avgProcessingTime_ = 0.0;
    private final ContainerAccessor containerAccessor_;
    private int fontsWaitingForMetrics_;
    private Phase currentPhase_;
    private List<byte[]> initialFontMetrics_;
    private List<FGInputEventDecoder.BinaryInput> pendingEvents_;
    private static boolean acceptingRequests_ = true;

    public FGContainerWebSocket(IFGTemplate iFGTemplate, FGContainerSessionHolder fGContainerSessionHolder, Consumer<IFGContainer> consumer, Consumer<FGRemoteAppContainer> consumer2, BiConsumer<Object, IFGContainer> biConsumer) {
        this.template_ = iFGTemplate;
        this.sessionHolder_ = fGContainerSessionHolder;
        this.containerConsumer_ = consumer;
        this.instanceConsumer_ = consumer2;
        this.sessionCloseConsumer_ = biConsumer;
        this.predictor_ = new FGPredictor();
        this.containerAccessor_ = new ContainerAccessor();
        FGAppServer.getFGLogger().info("WS Listener created " + System.identityHashCode(this));
    }

    public static void setAcceptingRequests(boolean bl) {
        acceptingRequests_ = bl;
    }

    public void onWebSocketClose(int n, String string) {
        FGAppServer.getFGLogger().info("WS Close " + System.identityHashCode(this) + " session: " + (this.fgSession_ != null ? this.fgSession_ : "<null>") + " remote: " + (this.session_ != null ? this.session_.getRemoteAddress() : "<null>") + " reason = " + string);
        if (this.sessionCloseConsumer_ != null) {
            this.sessionCloseConsumer_.accept(new FGSessionInfo(this.container_.getContainer().getId(), this.session_.getRemoteAddress()), this.container_.getContainer());
        }
        if (this.container_ != null) {
            this.container_.unInitialize();
        }
        if (this.fgSession_ != null) {
            this.sessionHolder_.stopSession(this.fgSession_.getSessionId());
            this.fgSession_.markIdle();
        }
        this.session_ = null;
        if (this.endpointTransportService_ != null) {
            this.endpointTransportService_.shutdown();
        }
    }

    public void onWebSocketConnect(Session session) {
        if (!this.sessionHolder_.memoryStateAllowsAcceptingNewSessions()) {
            session.close(new CloseStatus(1000, "Server memory state does not allow new sessions. Use alternative server."));
            FGAppServer.getFGLogger().info("Refused remote endpoint " + session.getRemoteAddress() + " because of the memory state");
            return;
        }
        if (!acceptingRequests_) {
            session.close(new CloseStatus(1000, "Server maintenance. Use alternative server."));
            FGAppServer.getFGLogger().info("Refused remote endpoint due to maintenance mode: " + session.getRemoteAddress());
            return;
        }
        this.session_ = session;
        this.endpointTransportService_ = Executors.newSingleThreadExecutor();
        FGAppServer.getFGLogger().info("WS Connect " + System.identityHashCode(this) + " session: " + this.fgSession_ + " remote: " + this.session_.getRemoteAddress());
        Set<String> set = this.findAllFonts();
        this.fontsWaitingForMetrics_ = set.size();
        this.initialFontMetrics_ = new ArrayList<byte[]>(this.fontsWaitingForMetrics_);
        this.pendingEvents_ = new ArrayList<FGInputEventDecoder.BinaryInput>();
        if (this.fontsWaitingForMetrics_ > 0) {
            this.currentPhase_ = Phase.CollectingMetrics;
            set.stream().forEach(string -> {
                FGAppServer.getFGLogger().info(this.session_.getRemoteAddress() + " Requesting metrics for font: " + string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FGWebContainerWrapper.StringTransmitter.writeString(byteArrayOutputStream, 1, string);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = 107;
                for (int i = 0; i < byArray.length; ++i) {
                    byArray2[i + 1] = byArray[i];
                }
                this.sendBytesToRemote(ByteBuffer.wrap(byArray2));
            });
        } else {
            this.currentPhase_ = Phase.Live;
            this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{100}));
            this.startContainer();
        }
    }

    public void onWebSocketError(Throwable throwable) {
        FGAppServer.getFGLogger().error(this.fgSession_ + " WS error: " + throwable.getMessage());
    }

    public synchronized void onWebSocketBinary(byte[] byArray, int n, int n2) {
        if (this.currentPhase_ == Phase.CollectingMetrics) {
            if (byArray[0] == 7) {
                this.initialFontMetrics_.add(byArray);
                --this.fontsWaitingForMetrics_;
                if (this.fontsWaitingForMetrics_ == 0) {
                    this.currentPhase_ = Phase.Live;
                    this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{100}));
                    this.startContainer();
                }
            } else {
                this.pendingEvents_.add(new FGInputEventDecoder.BinaryInput(byArray, n, n2));
            }
            return;
        }
        long l = System.currentTimeMillis();
        this.fgSession_.markAccesed();
        if (byArray.length > 0) {
            FGWebInteropUtil fGWebInteropUtil;
            if (byArray[0] == 7) {
                fGWebInteropUtil = (FGWebInteropUtil)this.container_.getContainer().getInterop();
                String string = fGWebInteropUtil.setMetricsTransmission(byArray);
                this.container_.markFontAsHavingReceivedMetrics(string);
            } else if (byArray[0] == 8) {
                this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{106}));
            } else {
                this.latestInputEventTimestamp_ = System.currentTimeMillis();
                fGWebInteropUtil = this.parser_.getInputEvent(new FGInputEventDecoder.BinaryInput(byArray, n, n2));
                this.predictor_.considerInputEvent(fGWebInteropUtil);
                this.processInputEvent(fGWebInteropUtil);
                this.container_.clearForks();
                this.predictionsSent_ = false;
            }
        }
        long l2 = System.currentTimeMillis() - l;
        this.avgProcessingTime_ = (this.avgProcessingTime_ * (double)this.totalInboundMessages_ + (double)l2) / (double)(this.totalInboundMessages_ + 1L);
        ++this.totalInboundMessages_;
    }

    public void onWebSocketText(String string) {
    }

    private Set<String> findAllFonts() {
        Var var = RT.var((String)this.template_.getContainerNamespace(), (String)this.template_.getContainerVarName());
        Map map = (Map)var.get();
        Set<String> set = this.getFonts(map);
        set.add(FGWebInteropUtil.getDefaultFontStr());
        return set;
    }

    private Set<String> getFonts(Map<Keyword, Object> map2) {
        Map map3;
        HashSet<String> hashSet = new HashSet<String>();
        Object object = map2.get(fontKey_);
        String string = (String)object;
        if (string != null) {
            hashSet.add(string);
        }
        if ((map3 = (Map)map2.get(childrenKey_)) != null) {
            map3.values().stream().forEach(map -> hashSet.addAll(this.getFonts((Map<Keyword, Object>)map)));
        }
        return hashSet;
    }

    private void startContainer() {
        StringBuilder stringBuilder = new StringBuilder("Creating session...");
        this.setTextToRemote(stringBuilder.toString());
        HashSet<String> hashSet = new HashSet<String>();
        this.fgSession_ = this.sessionHolder_.getSession(this.template_, this.session_.getRemoteAddress().getAddress(), this.initialFontMetrics_, hashSet, actionEvent -> this.collectUnsolicitedResponse());
        this.fgSession_.setAccosiatedWebSocket(this);
        stringBuilder.append("|created session");
        this.setTextToRemote(stringBuilder.toString());
        FGAppServer.getFGLogger().info("Initializing container " + System.identityHashCode(this) + " session: " + this.fgSession_ + " remote: " + this.session_.getRemoteAddress());
        this.container_ = this.fgSession_.getContainer();
        FGLegacyCoreGlue fGLegacyCoreGlue = (FGLegacyCoreGlue)this.container_.getContainer();
        if (this.instanceConsumer_ != null) {
            this.instanceConsumer_.accept(fGLegacyCoreGlue.getRemoteAppContainer());
        }
        hashSet.forEach(this.container_::markFontAsHavingReceivedMetrics);
        stringBuilder.append("|created app");
        this.setTextToRemote(stringBuilder.toString());
        if (this.containerConsumer_ != null) {
            this.containerConsumer_.accept(this.containerAccessor_);
        }
        stringBuilder.append("|initialized app");
        this.setTextToRemote(stringBuilder.toString());
        this.parser_ = this.fgSession_.getParser();
        stringBuilder.append("|retrieving initial state...");
        this.setTextToRemote(stringBuilder.toString());
        FGAppServer.getFGLogger().info("Container is up " + System.identityHashCode(this) + " session: " + this.fgSession_ + " remote: " + this.session_.getRemoteAddress());
        this.container_.resetCache();
        this.pendingEvents_.forEach(binaryInput -> this.onWebSocketBinary(binaryInput.getPayload(), binaryInput.getOffset(), binaryInput.getLen()));
        this.pendingEvents_.clear();
        this.collectAndSendResponse(null, false);
        FGAppServer.getFGLogger().info("Container ready " + System.identityHashCode(this) + " session: " + this.fgSession_ + " remote: " + this.session_.getRemoteAddress());
        this.container_.resetCache();
    }

    private boolean isStarted() {
        return this.container_ != null;
    }

    private void processInputEvent(Object object) {
        if (!this.isStarted()) {
            return;
        }
        if (object == null) {
            return;
        }
        Future<FGEvolveResultData> future = this.container_.feedEvent(new FGEvolveInputData(object, false));
        if (future != null) {
            this.collectAndSendResponse(future, object instanceof FGHostStateEvent);
        }
    }

    void collectAndSendResponse(Future<FGEvolveResultData> future, boolean bl) {
        Collection<ByteBuffer> collection = this.container_.getResponseForClient(future);
        this.sendResponseImpl(collection, bl);
    }

    void collectUnsolicitedResponse() {
        this.container_.getUnsolicitedResponseForClient(collection -> this.sendResponseImpl((Collection<ByteBuffer>)collection, false));
    }

    private void sendResponseImpl(Collection<ByteBuffer> collection, boolean bl) {
        if (collection.size() > 0) {
            collection.forEach(this::sendBytesToRemote);
            this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{65}));
        } else if (bl) {
            this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{65}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPredictionsIfNeeded() {
        FGContainerWebSocket fGContainerWebSocket = this;
        synchronized (fGContainerWebSocket) {
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = false;
            List<MouseEvent> list = this.predictor_.leftClickInLatestPosition();
            if (list != null) {
                for (int i = 0; i < FGWebContainerWrapper.MOUSE_LEFT_CLICK_PREDICTION_SEQUENCE.length; ++i) {
                    Future<FGEvolveResultData> future;
                    MouseEvent mouseEvent = list.get(i);
                    Collection<ByteBuffer> collection = this.container_.getForkedResponseForClient(mouseEvent, future = this.container_.feedEvent(new FGEvolveInputData(mouseEvent, true)));
                    if (collection.size() <= 0) continue;
                    this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{FGWebContainerWrapper.MOUSE_LEFT_CLICK_PREDICTION_SEQUENCE[i]}));
                    collection.forEach(this::sendBytesToRemote);
                    n3 += 1 + collection.stream().map(byteBuffer -> byteBuffer.capacity()).reduce((n, n2) -> n + n2).get();
                    bl2 = true;
                }
            }
            if (bl2) {
                this.sendBytesToRemote(ByteBuffer.wrap(new byte[]{100}));
                this.predictionsSent_ = true;
                if (n4 > 0) {
                    // empty if block
                }
            }
        }
    }

    double getAvgProcessingTime() {
        return this.avgProcessingTime_;
    }

    int getQueueSizeWaiting() {
        return this.container_.getContainer().getQueueSizeWaiting();
    }

    private void sendBytesToRemote(ByteBuffer byteBuffer) {
        this.endpointTransportService_.submit(() -> {
            try {
                this.session_.getRemote().sendBytes(byteBuffer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    }

    private void setTextToRemote(String string) {
        this.endpointTransportService_.submit(() -> {
            try {
                this.session_.getRemote().sendString(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    }

    public class ContainerAccessor
    implements IFGContainer {
        @Override
        public Future<FGEvolveResultData> feedTargetedEvent(List<Keyword> list, FGEvolveInputData fGEvolveInputData) {
            Future<FGEvolveResultData> future = FGContainerWebSocket.this.container_.feedTargetedEvent(list, fGEvolveInputData);
            FGContainerWebSocket.this.collectAndSendResponse(future, false);
            return null;
        }

        @Override
        public Future<FGEvolveResultData> feedTargetedEvent(List<Keyword> list, Object object) {
            return this.feedTargetedEvent(list, new FGEvolveInputData(object, false));
        }

        @Override
        public String getId() {
            return FGContainerWebSocket.this.container_.getContainer().getId();
        }

        @Override
        public void initialize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unInitialize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isActive() {
            return FGContainerWebSocket.this.container_.getContainer().isActive();
        }

        @Override
        public void addEvolveConsumer(IFGEvolveConsumer iFGEvolveConsumer) {
            FGContainerWebSocket.this.container_.getContainer().addEvolveConsumer(iFGEvolveConsumer);
        }

        @Override
        public IFGModule getFGModule() {
            return FGContainerWebSocket.this.container_.getContainer().getFGModule();
        }

        @Override
        public IFGModule getForkedFGModule(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IFGInteropUtil getInterop() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Function<FGEvolveInputData, Future<FGEvolveResultData>> connect(ActionListener actionListener, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submitTask(Callable<T> callable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<FGEvolveResultData> feedEvent(FGEvolveInputData fGEvolveInputData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Keyword> getLastMouseTargetIdPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getQueueSizeWaiting() {
            throw new UnsupportedOperationException();
        }
    }

    public static class FGSessionInfo {
        private final Object containerId_;
        private final Object removeAddr_;

        public FGSessionInfo(Object object, Object object2) {
            this.containerId_ = object;
            this.removeAddr_ = object2;
        }

        public String toString() {
            return this.containerId_ + "/" + this.removeAddr_;
        }
    }

    private static enum Phase {
        CollectingMetrics,
        Live;

    }
}

