/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util;

import flatgui.util.IMatrix;
import flatgui.util.IObjectListCoder;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class CompactList<T, Data extends IObjectListCoder<T> & IMatrix<T>>
extends AbstractList<T>
implements RandomAccess {
    static final int[] DISTRIBUTION;
    private static final int[] INDICES;
    private static final int[] SHIFTS;
    private static final int[] MASKS;
    private static final long[][] MASKS_FOR_SIZE;
    private static final int SIZE_PLACE;
    private static final int LONG_CAPACITY;
    private final Data objectData_;
    private final long[] numData_;

    public CompactList(Data Data) {
        this.objectData_ = Data;
        this.numData_ = new long[LONG_CAPACITY];
    }

    public CompactList(Data Data, int[] nArray) {
        this.objectData_ = Data;
        this.numData_ = new long[LONG_CAPACITY];
        this.addNumData(nArray);
    }

    public CompactList(Data Data, List<T> list) {
        if (list.size() > DISTRIBUTION.length - 1) {
            throw new UnsupportedOperationException("Can handle up to " + (DISTRIBUTION.length - 1) + " elements");
        }
        if (list instanceof CompactList) {
            this.objectData_ = Data;
            this.numData_ = new long[LONG_CAPACITY];
            for (int i = 0; i < this.numData_.length; ++i) {
                this.numData_[i] = ((CompactList)list).numData_[i];
            }
        } else {
            this.objectData_ = Data;
            this.numData_ = new long[LONG_CAPACITY];
            int[] nArray = Data.addPath(list);
            this.addNumData(nArray);
        }
    }

    @Override
    public T get(int n) {
        int n2 = this.getSlot(n);
        return ((IMatrix)this.objectData_).get(n, n2);
    }

    @Override
    public int size() {
        return this.getSlot(SIZE_PLACE);
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    public boolean add(T t) {
        int n = this.size();
        if (n == DISTRIBUTION.length - 1) {
            throw new UnsupportedOperationException("List already contains the maximum of " + (DISTRIBUTION.length - 1) + " elements");
        }
        int n2 = ((IMatrix)this.objectData_).addIfAbsent(n, t);
        this.setSlot(n, n2);
        this.setSlot(SIZE_PLACE, n + 1);
        return true;
    }

    @Override
    public T set(int n, T t) {
        if (n < this.size()) {
            T t2 = this.get(n);
            int n2 = ((IMatrix)this.objectData_).addIfAbsent(n, t);
            this.setSlot(n, n2);
            return t2;
        }
        throw new IndexOutOfBoundsException("Could set element at " + n + ": list size = " + this.size());
    }

    @Override
    public T remove(int n) {
        int n2 = this.size();
        if (n == n2 - 1) {
            T t = this.get(n);
            this.setSlot(n, 0);
            this.setSlot(SIZE_PLACE, n2 - 1);
            return t;
        }
        throw new UnsupportedOperationException("Cannot remove element at " + n + " index in the list of size " + n2 + ". Only last element removal is supported.");
    }

    @Override
    public void replaceAll(UnaryOperator<T> unaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<T> stream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<T> parallelStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompactList) {
            int n;
            int n2 = this.size();
            if (n2 == (n = ((CompactList)object).size())) {
                if (n2 == 0) {
                    return true;
                }
                for (int i = 0; i <= INDICES[n2 - 1]; ++i) {
                    if ((this.numData_[i] & MASKS_FOR_SIZE[n2][i]) == (((CompactList)object).numData_[i] & MASKS_FOR_SIZE[n2][i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return super.equals(object);
    }

    final int getSlot(int n) {
        int n2 = SHIFTS[n];
        int n3 = INDICES[n];
        return (int)(this.numData_[n3] >> n2 & (long)MASKS[n]);
    }

    final void setSlot(int n, int n2) {
        int n3;
        int n4 = SHIFTS[n];
        int n5 = n3 = INDICES[n];
        this.numData_[n5] = this.numData_[n5] & ((long)MASKS[n] << n4 ^ 0xFFFFFFFFFFFFFFFFL);
        int n6 = n3;
        this.numData_[n6] = this.numData_[n6] | (long)(n2 & MASKS[n]) << n4;
    }

    private final void addNumData(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.setSlot(i, nArray[i]);
        }
        this.setSlot(SIZE_PLACE, nArray.length);
    }

    static {
        int n;
        DISTRIBUTION = new int[]{10, 10, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 4};
        INDICES = new int[DISTRIBUTION.length];
        SHIFTS = new int[DISTRIBUTION.length];
        MASKS = new int[DISTRIBUTION.length];
        int n2 = 0;
        for (n = 0; n < DISTRIBUTION.length; ++n) {
            CompactList.INDICES[n] = n2 / 64;
            CompactList.SHIFTS[n] = n2 % 64;
            CompactList.MASKS[n] = (1 << DISTRIBUTION[n]) - 1;
            n2 += DISTRIBUTION[n];
        }
        LONG_CAPACITY = n2 / 64;
        SIZE_PLACE = DISTRIBUTION.length - 1;
        MASKS_FOR_SIZE = new long[DISTRIBUTION.length][LONG_CAPACITY];
        long[] lArray = new long[LONG_CAPACITY];
        for (n = 0; n < DISTRIBUTION.length; ++n) {
            int n3 = INDICES[n];
            lArray[n3] = lArray[n3] | (long)MASKS[n] << SHIFTS[n];
            long[] lArray2 = MASKS_FOR_SIZE[n];
            int n4 = INDICES[n];
            lArray2[n4] = lArray2[n4] | lArray[INDICES[n]];
            for (int i = 0; i < INDICES[n]; ++i) {
                CompactList.MASKS_FOR_SIZE[n][i] = -1L;
            }
        }
    }
}

