/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util;

import flatgui.util.GrowControlArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GrowControlArrayListTest {
    @Test
    public void testGrow1() {
        GrowAdd growAdd = new GrowAdd(2);
        GrowControlArrayList<String> growControlArrayList = new GrowControlArrayList<String>(3, (GrowControlArrayList.GrowFunction)growAdd);
        Assert.assertEquals((long)3L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)0L, (long)growControlArrayList.size());
        growControlArrayList.add("a");
        Assert.assertEquals((long)3L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)1L, (long)growControlArrayList.size());
        growControlArrayList.add("b");
        Assert.assertEquals((long)3L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)2L, (long)growControlArrayList.size());
        growControlArrayList.add("c");
        Assert.assertEquals((long)3L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)3L, (long)growControlArrayList.size());
        growControlArrayList.add("d");
        Assert.assertEquals((long)5L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)4L, (long)growControlArrayList.size());
        Assert.assertEquals(Arrays.asList(new GrowCallLog(3, 1)), growAdd.getLog());
        Assert.assertEquals(Arrays.asList("a", "b", "c", "d"), growControlArrayList);
    }

    @Test
    public void testGrow3() {
        GrowAdd growAdd = new GrowAdd(3);
        GrowControlArrayList<String> growControlArrayList = new GrowControlArrayList<String>(0, (GrowControlArrayList.GrowFunction)growAdd);
        Assert.assertEquals((long)0L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)0L, (long)growControlArrayList.size());
        growControlArrayList.add("a");
        Assert.assertEquals((long)3L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)1L, (long)growControlArrayList.size());
        growControlArrayList.add("b");
        Assert.assertEquals((long)3L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)2L, (long)growControlArrayList.size());
        growControlArrayList.add("c");
        Assert.assertEquals((long)3L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)3L, (long)growControlArrayList.size());
        growControlArrayList.add("d");
        Assert.assertEquals((long)6L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)4L, (long)growControlArrayList.size());
        growControlArrayList.add("e");
        Assert.assertEquals((long)6L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)5L, (long)growControlArrayList.size());
        growControlArrayList.add("f");
        Assert.assertEquals((long)6L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)6L, (long)growControlArrayList.size());
        Assert.assertEquals(Arrays.asList(new GrowCallLog(0, 1), new GrowCallLog(3, 1)), growAdd.getLog());
        Assert.assertEquals(Arrays.asList("a", "b", "c", "d", "e", "f"), growControlArrayList);
    }

    @Test
    public void testClear() {
        GrowControlArrayList<String> growControlArrayList = new GrowControlArrayList<String>(2, null);
        Assert.assertEquals((long)2L, (long)growControlArrayList.getCapacity());
        Assert.assertEquals((long)0L, (long)growControlArrayList.size());
        growControlArrayList.add("a");
        growControlArrayList.add("b");
        growControlArrayList.clear();
        Assert.assertEquals((long)0L, (long)growControlArrayList.size());
    }

    private static class GrowAdd
    implements GrowControlArrayList.GrowFunction {
        private final int inc_;
        private List<GrowCallLog> log_;

        GrowAdd(int n) {
            this.inc_ = n;
            this.log_ = new ArrayList<GrowCallLog>();
        }

        List<GrowCallLog> getLog() {
            return this.log_;
        }

        void clearLog() {
            this.log_.clear();
        }

        @Override
        public int apply(int n, int n2) {
            int n3 = Math.max(this.inc_, n2);
            this.log_.add(new GrowCallLog(n, n2));
            return n + n3;
        }
    }

    private static class GrowCallLog {
        private int oldSize_;
        private int increment_;

        public GrowCallLog(int n, int n2) {
            this.oldSize_ = n;
            this.increment_ = n2;
        }

        int getOldSize() {
            return this.oldSize_;
        }

        int getIncrement() {
            return this.increment_;
        }

        public String toString() {
            return "{oldSize_=" + this.oldSize_ + ", increment_=" + this.increment_ + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GrowCallLog growCallLog = (GrowCallLog)object;
            if (this.oldSize_ != growCallLog.oldSize_) {
                return false;
            }
            return this.increment_ == growCallLog.increment_;
        }
    }
}

