/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine.ui;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FGTransferable
implements Transferable {
    private final DataFlavor[] flavors_;
    private final Map<DataFlavor, Object> data_;

    private FGTransferable(Map<DataFlavor, Object> map) {
        this.data_ = map;
        this.flavors_ = map.keySet().toArray(new DataFlavor[map.size()]);
    }

    public static FGTransferable createTextTransferable(String string) {
        HashMap<DataFlavor, Object> hashMap = new HashMap<DataFlavor, Object>();
        hashMap.put(DataFlavor.stringFlavor, string);
        return new FGTransferable(hashMap);
    }

    public static FGTransferable createImageTransferable(Image image) {
        HashMap<DataFlavor, Object> hashMap = new HashMap<DataFlavor, Object>();
        hashMap.put(DataFlavor.imageFlavor, image);
        return new FGTransferable(hashMap);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors_;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.data_.keySet().contains(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.data_.get(dataFlavor);
    }
}

