/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine;

import flatgui.core.IFGEvolveConsumer;
import flatgui.core.engine.Container;
import flatgui.util.CompactList;
import flatgui.util.ObjectMatrix;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class Node {
    private static final String NO_EVOLVER_MSG = "Should not be called since this node declares no evolver/dependencies";
    private final int componentUid_;
    private final int parentComponentUid_;
    private final int nodeUid_;
    protected final Container.SourceNode sourceNode_;
    private final Map<Integer, List<Object>> dependentIndexToRelPath_;

    public Node(Integer n, int n2, Container.SourceNode sourceNode, int n3) {
        this.componentUid_ = n;
        this.parentComponentUid_ = n2;
        this.sourceNode_ = sourceNode;
        this.nodeUid_ = n3;
        this.dependentIndexToRelPath_ = new HashMap<Integer, List<Object>>();
    }

    Node(Node node) {
        this.componentUid_ = node.componentUid_;
        this.parentComponentUid_ = node.parentComponentUid_;
        this.sourceNode_ = node.sourceNode_;
        this.nodeUid_ = node.nodeUid_;
        this.dependentIndexToRelPath_ = new HashMap<Integer, List<Object>>(node.dependentIndexToRelPath_);
    }

    public Integer getComponentUid() {
        return this.componentUid_;
    }

    public Object getPropertyId() {
        return this.sourceNode_.getPropertyId();
    }

    public int getParentComponentUid() {
        return this.parentComponentUid_;
    }

    public boolean isChildrenProperty() {
        return this.sourceNode_.isChildrenProperty();
    }

    public boolean isChildOrderProperty() {
        return this.sourceNode_.isChildOrderProperty();
    }

    public int getNodeIndex() {
        return this.nodeUid_;
    }

    public List<Object> getNodePath() {
        return this.sourceNode_.getNodePath();
    }

    public Map<Integer, List<Object>> getDependentIndices() {
        return this.dependentIndexToRelPath_;
    }

    public void addDependent(Integer n, List<Object> list, List<Object> list2, ObjectMatrix<Object> objectMatrix) {
        CompactList<Object, ObjectMatrix<Object>> compactList = new CompactList<Object, ObjectMatrix<Object>>(objectMatrix, list2);
        int n2 = this.sourceNode_.getNodePath().size();
        if (list.size() < n2) {
            for (int i = 1; i < list2.size(); ++i) {
                compactList.set(i, this.sourceNode_.getNodePath().get(n2 - list2.size() + i));
            }
        }
        if (Container.debug_) {
            Container.logDebug(this.nodeUid_ + " " + this.sourceNode_.getNodePath() + " added dependent: " + n + " " + list + " referenced as " + list2 + " actual ref " + compactList);
        }
        this.dependentIndexToRelPath_.put(n, compactList);
    }

    public void removeDependent(Integer n) {
        this.dependentIndexToRelPath_.remove(n);
    }

    public Collection<Object> getInputDependencies() {
        return Collections.emptyList();
    }

    public boolean isHasAmbiguousDependencies() {
        return false;
    }

    public void resolveDependencyIndices(List<Container.ComponentAccessor> list, Predicate<Object> predicate) {
    }

    public Collection<Dependency> reevaluateAmbiguousDependencies(List<Container.ComponentAccessor> list, Predicate<Object> predicate) {
        throw new IllegalStateException(NO_EVOLVER_MSG);
    }

    public Collection<Dependency> getDependencyIndices() {
        return Collections.emptyList();
    }

    public Object getEvolverCode() {
        return null;
    }

    public Function<Map<Object, Object>, Object> getEvolver() {
        return null;
    }

    void forgetDependency(Integer n) {
        throw new IllegalStateException(NO_EVOLVER_MSG);
    }

    void addEvolveConsumer(IFGEvolveConsumer iFGEvolveConsumer) {
        throw new IllegalStateException(NO_EVOLVER_MSG);
    }

    Collection<IFGEvolveConsumer> getEvolveConsumers() {
        return Collections.emptyList();
    }

    public static class Dependency {
        private final int nodeIndex_;
        private final List<Object> relPath_;

        public Dependency(int n, List<Object> list) {
            this.nodeIndex_ = n;
            this.relPath_ = list;
        }

        public int getNodeIndex() {
            return this.nodeIndex_;
        }

        public List<Object> getRelPath() {
            return this.relPath_;
        }
    }
}

