/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import flatgui.core.IFGEvolveConsumer;
import flatgui.core.engine.Container;
import flatgui.core.engine.GetPropertyDelegate;
import flatgui.core.engine.GetPropertyStaticClojureFn;
import flatgui.core.engine.IEvolverWrapper;
import flatgui.core.engine.Node;
import flatgui.util.CompactList;
import flatgui.util.ObjectMatrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EvolvingNode
extends Node
implements Function<Map<Object, Object>, Object>,
IEvolverWrapper {
    private List<Node.Dependency> dependencyIndices_;
    private Set<IFGEvolveConsumer> evolveConsumers_;
    private final List<Object> evolvedComponentPath_;
    private final Set<GetPropertyDelegate> allDelegates_;
    private final Container.IEvolverAccess evolverAccess_;

    public EvolvingNode(Integer n, int n2, Container.SourceNode sourceNode, int n3, Container.IEvolverAccess iEvolverAccess) {
        super(n, n2, sourceNode, n3);
        this.allDelegates_ = new HashSet<GetPropertyDelegate>();
        this.evolverAccess_ = iEvolverAccess;
        this.evolvedComponentPath_ = this.dropLast(sourceNode.getNodePath());
    }

    EvolvingNode(EvolvingNode evolvingNode, Container.IEvolverAccess iEvolverAccess) {
        super(evolvingNode);
        this.dependencyIndices_ = new ArrayList<Node.Dependency>(evolvingNode.dependencyIndices_.size());
        this.dependencyIndices_.addAll(evolvingNode.dependencyIndices_.stream().collect(Collectors.toList()));
        this.evolvedComponentPath_ = evolvingNode.evolvedComponentPath_;
        this.allDelegates_ = new HashSet<GetPropertyDelegate>();
        this.evolverAccess_ = iEvolverAccess;
    }

    @Override
    public Collection<Object> getInputDependencies() {
        return this.sourceNode_.getInputDependencies();
    }

    @Override
    public boolean isHasAmbiguousDependencies() {
        return this.sourceNode_.isHasAmbiguousDependencies();
    }

    private void findNodeIndices(Container.ComponentAccessor componentAccessor, int n, Container.DependencyInfo dependencyInfo, List<Container.ComponentAccessor> list, Predicate<Object> predicate, Consumer<Node.Dependency> consumer) {
        List<Object> list2 = dependencyInfo.getAbsPath();
        int n2 = list2.size();
        if (n2 == 1) {
            return;
        }
        Object object = list2.get(n);
        if (n < n2 - 1) {
            if (predicate.test(object)) {
                List<Integer> list3 = componentAccessor.getChildIndices();
                for (Integer n3 : list3) {
                    this.findNodeIndices(list.get(n3), n + 1, dependencyInfo, list, predicate, consumer);
                }
            } else {
                Integer n4 = componentAccessor.getChildIndex(object);
                if (n4 != null) {
                    this.findNodeIndices(list.get(n4), n + 1, dependencyInfo, list, predicate, consumer);
                }
            }
        } else {
            Integer n5 = componentAccessor.getPropertyIndex(object);
            if (n5 != null) {
                Node.Dependency dependency2 = new Node.Dependency(n5, dependencyInfo.getRelPath());
                this.dependencyIndices_.add(dependency2);
                if (consumer != null) {
                    consumer.accept(dependency2);
                }
            }
        }
    }

    @Override
    public void resolveDependencyIndices(List<Container.ComponentAccessor> list, Predicate<Object> predicate) {
        Collection<Container.DependencyInfo> collection = this.sourceNode_.getRelAndAbsDependencyPaths();
        this.dependencyIndices_ = new ArrayList<Node.Dependency>(collection.size());
        for (Container.DependencyInfo dependencyInfo : collection) {
            this.findNodeIndices(list.get(0), 1, dependencyInfo, list, predicate, null);
        }
    }

    @Override
    public Collection<Node.Dependency> reevaluateAmbiguousDependencies(List<Container.ComponentAccessor> list, Predicate<Object> predicate) {
        ArrayList<Node.Dependency> arrayList = new ArrayList<Node.Dependency>();
        for (Container.DependencyInfo dependencyInfo : this.sourceNode_.getRelAndAbsDependencyPaths()) {
            this.findNodeIndices(list.get(0), 1, dependencyInfo, list, predicate, arrayList::add);
        }
        return arrayList;
    }

    @Override
    public Collection<Node.Dependency> getDependencyIndices() {
        return this.dependencyIndices_;
    }

    @Override
    public Object getEvolverCode() {
        return this.sourceNode_.getEvolverCode();
    }

    @Override
    public Function<Map<Object, Object>, Object> getEvolver() {
        return this;
    }

    @Override
    void forgetDependency(Integer n) {
        for (int i = 0; i < this.dependencyIndices_.size(); ++i) {
            if (this.dependencyIndices_.get(i).getNodeIndex() != n.intValue()) continue;
            this.dependencyIndices_.remove(i);
            break;
        }
        this.unlinkAllDelegates();
    }

    @Override
    void addEvolveConsumer(IFGEvolveConsumer iFGEvolveConsumer) {
        if (this.evolveConsumers_ == null) {
            this.evolveConsumers_ = new HashSet<IFGEvolveConsumer>();
        }
        this.evolveConsumers_.add(iFGEvolveConsumer);
    }

    @Override
    Collection<IFGEvolveConsumer> getEvolveConsumers() {
        return this.evolveConsumers_;
    }

    @Override
    public Object apply(Map<Object, Object> map) {
        GetPropertyStaticClojureFn.visit(this);
        return ((IFn)this.getEvolverCode()).invoke(map);
    }

    @Override
    public GetPropertyDelegate getDelegateById(int n) {
        GetPropertyDelegate getPropertyDelegate = this.evolverAccess_.getDelegateByIdMap().get(this.getDelegateKey(n));
        if (getPropertyDelegate == null) {
            getPropertyDelegate = this.createDelegate();
            this.evolverAccess_.getDelegateByIdMap().put(this.getDelegateKey(n), getPropertyDelegate);
        }
        return getPropertyDelegate;
    }

    @Override
    public GetPropertyDelegate getDelegateByIdAndPath(int n, List<Object> list) {
        GetPropertyDelegate getPropertyDelegate;
        Map<List<Object>, GetPropertyDelegate> map = this.evolverAccess_.getDelegateByIdAndPathMap().get(this.getDelegateKey(n));
        if (map == null) {
            map = new HashMap<List<Object>, GetPropertyDelegate>();
            this.evolverAccess_.getDelegateByIdAndPathMap().put(this.getDelegateKey(n), map);
        }
        if ((getPropertyDelegate = map.get(list)) == null) {
            getPropertyDelegate = this.createDelegate();
            map.put(list, getPropertyDelegate);
        }
        return getPropertyDelegate;
    }

    @Override
    public GetPropertyDelegate getDelegateByIdAndProperty(int n, Keyword keyword) {
        GetPropertyDelegate getPropertyDelegate;
        Map<Keyword, GetPropertyDelegate> map = this.evolverAccess_.getDelegateByIdAndPropertyMap().get(this.getDelegateKey(n));
        if (map == null) {
            map = new HashMap<Keyword, GetPropertyDelegate>();
            this.evolverAccess_.getDelegateByIdAndPropertyMap().put(this.getDelegateKey(n), map);
        }
        if ((getPropertyDelegate = map.get(keyword)) == null) {
            getPropertyDelegate = this.createDelegate();
            map.put(keyword, getPropertyDelegate);
        }
        return getPropertyDelegate;
    }

    @Override
    public GetPropertyDelegate getDelegateByIdPathAndProperty(int n, List<Object> list, Keyword keyword) {
        GetPropertyDelegate getPropertyDelegate;
        Map<Keyword, GetPropertyDelegate> map;
        Map<List<Object>, Map<Keyword, GetPropertyDelegate>> map2 = this.evolverAccess_.getDelegateByIdPathAndPropertyMap().get(this.getDelegateKey(n));
        if (map2 == null) {
            map2 = new HashMap<List<Object>, Map<Keyword, GetPropertyDelegate>>();
            this.evolverAccess_.getDelegateByIdPathAndPropertyMap().put(this.getDelegateKey(n), map2);
        }
        if ((map = map2.get(list)) == null) {
            map = new HashMap<Keyword, GetPropertyDelegate>();
            map2.put(list, map);
        }
        if ((getPropertyDelegate = map.get(keyword)) == null) {
            getPropertyDelegate = this.createDelegate();
            map.put(keyword, getPropertyDelegate);
        }
        return getPropertyDelegate;
    }

    void unlinkAllDelegates() {
        this.allDelegates_.forEach(getPropertyDelegate -> getPropertyDelegate.unlink());
    }

    private GetPropertyDelegate createDelegate() {
        GetPropertyDelegate getPropertyDelegate = new GetPropertyDelegate(this.evolvedComponentPath_, this.evolverAccess_);
        this.allDelegates_.add(getPropertyDelegate);
        return getPropertyDelegate;
    }

    private Integer getDelegateKey(int n) {
        return (this.getNodeIndex() << 14) + n;
    }

    private List<Object> dropLast(List<Object> list) {
        CompactList<Object, ObjectMatrix<Object>> compactList = new CompactList<Object, ObjectMatrix<Object>>(this.evolverAccess_.getKeyMatrix(), list);
        compactList.remove(compactList.size() - 1);
        return compactList;
    }
}

