/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util;

import flatgui.util.IMatrix;
import flatgui.util.IObjectListCoder;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public class ObjectMatrix<T>
implements RandomAccess,
IObjectListCoder<T>,
IMatrix<T> {
    private static final int ROW_CAPACITY = 12;
    private static final int COL_CAPACITY = 4096;
    private final T[][] data_ = new Object[12][4096];
    private final int[] rowSizes_ = new int[12];

    @Override
    public int[] addPath(List<T> list) {
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            T t = list.get(i);
            int n2 = this.indexOfInRow(t, i);
            if (n2 == -1) {
                n2 = this.addToRow(t, i);
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    @Override
    public T get(int n, int n2) {
        return this.data_[n][n2];
    }

    @Override
    public int addIfAbsent(int n, T t) {
        int n2 = this.indexOfInRow(t, n);
        if (n2 >= 0) {
            return n2;
        }
        int n3 = this.rowSizes_[n];
        this.data_[n][n3] = t;
        this.rowSizes_[n] = n3 + 1;
        return n3;
    }

    int indexOfInRow(T t, int n) {
        for (int i = 0; i < this.rowSizes_[n]; ++i) {
            if (!Objects.equals(t, this.data_[n][i])) continue;
            return i;
        }
        return -1;
    }

    int addToRow(T t, int n) {
        int n2 = this.rowSizes_[n];
        this.data_[n][n2] = t;
        int n3 = n;
        this.rowSizes_[n3] = this.rowSizes_[n3] + 1;
        return n2;
    }
}

