/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGContainer;
import flatgui.core.FGWebContainerWrapper;
import flatgui.core.IFGContainerHost;
import flatgui.core.IFGTemplate;
import flatgui.core.engine.remote.FGLegacyCoreGlue;
import flatgui.core.engine.remote.FGLegacyGlueTemplate;
import flatgui.core.engine.ui.FGRemoteAppContainer;
import flatgui.core.engine.ui.FGRemoteClojureResultCollector;
import flatgui.core.websocket.FGAppServer;
import flatgui.core.websocket.FGContainerSession;
import flatgui.core.websocket.FGWebInteropUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

class FGContainerSessionHolder {
    private static final String SPECIAL_CHARS = ".:/=";
    private static final int MEGABYTE = 0x100000;
    private static final int SECOND = 1000;
    private static final long LONG_IDLE_SESSION_TIMEOUT = 900000L;
    private static final long SHORT_IDLE_SESSION_TIMEOUT = 30000L;
    private static final double CANNOT_ACCEPT_MEMORY_RATIO = 0.9;
    private static final double VERY_LOW_MEMORY_RATIO = 0.75;
    private static final double LOW_MEMORY_RATIO = 0.6;
    private final IFGContainerHost<FGContainerSession> sessionHost_;
    private final Map<Object, FGContainerSession> sessionMap_;
    private static long counter_ = 0L;

    FGContainerSessionHolder(IFGContainerHost<FGContainerSession> iFGContainerHost) {
        this.sessionHost_ = iFGContainerHost;
        this.sessionMap_ = new ConcurrentHashMap<Object, FGContainerSession>();
        Timer timer2 = new Timer("FlatGUI web container long idle session cleaner", true);
        timer2.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FGContainerSessionHolder fGContainerSessionHolder = FGContainerSessionHolder.this;
                synchronized (fGContainerSessionHolder) {
                    FGContainerSessionHolder.this.cleanIdleSessions(900000L, "long cleaner");
                }
            }
        }, 900000L, 900000L);
        Timer timer3 = new Timer("FlatGUI web container short idle session cleaner", true);
        timer3.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FGContainerSessionHolder fGContainerSessionHolder = FGContainerSessionHolder.this;
                synchronized (fGContainerSessionHolder) {
                    HeapMemoryState heapMemoryState = FGContainerSessionHolder.getHeapMemoryState(false);
                    if (heapMemoryState != HeapMemoryState.Ok) {
                        FGContainerSessionHolder.this.cleanIdleSessions(30000L, "short cleaner");
                    }
                }
            }
        }, 30000L, 30000L);
    }

    private void cleanIdleSessions(long l, String string) {
        int n = this.sessionMap_.size();
        this.sessionMap_.entrySet().removeIf(entry -> ((FGContainerSession)entry.getValue()).isIdle(l));
        int n2 = this.sessionMap_.size();
        if (n2 != n) {
            FGAppServer.getFGLogger().info(this.toString() + " cleaned sessions (" + string + "). Before: " + n + "; after: " + n2 + ".");
        }
    }

    FGContainerSession getSession(IFGTemplate iFGTemplate, InetAddress inetAddress, List<byte[]> list, Set<String> set) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        long l = memoryUsage.getMax() / 0x100000L;
        long l2 = memoryUsage.getUsed() / 0x100000L;
        FGAppServer.getFGLogger().info("[creating session] " + l2 + " of " + l + " MB of heap used, " + this.sessionMap_.size() + " sessions");
        Object object = FGContainerSessionHolder.getSessionId(iFGTemplate, inetAddress);
        FGContainerSession fGContainerSession = this.sessionMap_.computeIfAbsent(object, object2 -> {
            if (iFGTemplate instanceof FGLegacyGlueTemplate) {
                Var var = RT.var((String)iFGTemplate.getContainerNamespace(), (String)iFGTemplate.getContainerVarName());
                Map map = (Map)var.get();
                FGLegacyCoreGlue.GlueModule glueModule = new FGLegacyCoreGlue.GlueModule(object.toString());
                FGWebContainerWrapper.KeyCache keyCache = new FGWebContainerWrapper.KeyCache();
                HashSet<String> hashSet = new HashSet<String>();
                FGRemoteClojureResultCollector fGRemoteClojureResultCollector = new FGRemoteClojureResultCollector(64, keyCache, glueModule, hashSet);
                FGRemoteAppContainer fGRemoteAppContainer = new FGRemoteAppContainer(object.toString(), (Map<Object, Object>)map, fGRemoteClojureResultCollector);
                FGLegacyCoreGlue fGLegacyCoreGlue = new FGLegacyCoreGlue(fGRemoteAppContainer, glueModule);
                FGWebInteropUtil fGWebInteropUtil = (FGWebInteropUtil)fGRemoteAppContainer.getInteropUtil();
                list.forEach(byArray -> set.add(fGWebInteropUtil.setMetricsTransmission((byte[])byArray)));
                FGContainerSession fGContainerSession = this.sessionHost_.hostContainer(fGLegacyCoreGlue, hashSet);
                return fGContainerSession;
            }
            FGWebInteropUtil fGWebInteropUtil = new FGWebInteropUtil(64);
            list.forEach(byArray -> set.add(fGWebInteropUtil.setMetricsTransmission((byte[])byArray)));
            FGContainer fGContainer = new FGContainer(iFGTemplate, object.toString(), fGWebInteropUtil);
            HashSet<String> hashSet = new HashSet<String>();
            return this.sessionHost_.hostContainer(fGContainer, hashSet);
        });
        FGAppServer.getFGLogger().debug(this.toString() + " state:");
        FGAppServer.getFGLogger().debug(this.sessionMap_.toString());
        FGAppServer.getFGLogger().debug(this.toString() + " returning for remoteAddress=" + inetAddress + " session: " + fGContainerSession);
        return fGContainerSession;
    }

    void stopSession(Object object) {
        HeapMemoryState heapMemoryState = FGContainerSessionHolder.getHeapMemoryState(true);
        if (heapMemoryState == HeapMemoryState.VeryLow || heapMemoryState == HeapMemoryState.CannotAccept) {
            FGAppServer.getFGLogger().info("Killing stopped session '" + object + "' because memory state is: " + (Object)((Object)heapMemoryState));
            this.sessionMap_.remove(object);
        }
    }

    synchronized long getActiveOrIdleSessionCount() {
        return this.sessionMap_.size();
    }

    synchronized long getActiveSessionCount() {
        return this.sessionMap_.values().stream().filter(FGContainerSession::isActive).count();
    }

    synchronized void forEachActiveSession(Consumer<FGContainerSession> consumer) {
        this.sessionMap_.values().forEach(fGContainerSession -> {
            Object object = fGContainerSession.getContainerLock();
            synchronized (object) {
                if (fGContainerSession.isActive()) {
                    consumer.accept((FGContainerSession)fGContainerSession);
                }
            }
        });
    }

    synchronized void forEachActiveSession(BiConsumer<Object, FGContainerSession> biConsumer) {
        this.sessionMap_.entrySet().forEach(entry -> {
            Object object = ((FGContainerSession)entry.getValue()).getContainerLock();
            synchronized (object) {
                if (((FGContainerSession)entry.getValue()).isActive()) {
                    biConsumer.accept(entry.getKey(), (FGContainerSession)entry.getValue());
                }
            }
        });
    }

    synchronized <R> Stream<R> mapSessions(Function<FGContainerSession, R> function) {
        return this.sessionMap_.values().stream().map(function);
    }

    static HeapMemoryState getHeapMemoryState(boolean bl) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        double d = memoryUsage.getMax();
        double d2 = memoryUsage.getUsed();
        double d3 = d2 / d;
        if (bl) {
            FGAppServer.getFGLogger().info("Memory state: " + (int)(d2 / 1048576.0) + " of " + (int)(d / 1048576.0) + " MB of heap used, ratio = " + d3);
        }
        if (d3 > 0.9) {
            return HeapMemoryState.CannotAccept;
        }
        if (d3 > 0.75) {
            return HeapMemoryState.VeryLow;
        }
        if (d3 > 0.6) {
            return HeapMemoryState.Low;
        }
        return HeapMemoryState.Ok;
    }

    private static Object getSessionId(IFGTemplate iFGTemplate, InetAddress inetAddress) {
        String string = iFGTemplate.getContainerNamespace() + "_" + iFGTemplate.getContainerVarName() + "_" + inetAddress.getHostAddress().toString() + String.valueOf(counter_);
        ++counter_;
        for (int i = 0; i < SPECIAL_CHARS.length(); ++i) {
            string = string.replace(SPECIAL_CHARS.charAt(i), '_');
        }
        return string;
    }

    static enum HeapMemoryState {
        Ok,
        Low,
        VeryLow,
        CannotAccept;

    }
}

