/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import flatgui.core.FGClipboardEvent;
import flatgui.core.FGHostStateEvent;
import flatgui.core.engine.ui.FGKeyEventParser;
import flatgui.core.engine.ui.FGTransferable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;

public class FGInputEventDecoder {
    public static final Component dummySourceComponent_ = new Container();
    private Collection<IParser<BinaryInput, ?>> binaryParsers_ = new ArrayList();

    public FGInputEventDecoder() {
        this.addBinaryParser(new MouseBinaryParser());
        this.addBinaryParser(new KeyBinaryParser());
        this.addBinaryParser(new ClipboardBinaryParser());
        this.addBinaryParser(new HostEventBinaryParser());
    }

    public final void addBinaryParser(IParser<BinaryInput, ?> iParser) {
        this.binaryParsers_.add(iParser);
    }

    public <E> E getInputEvent(BinaryInput binaryInput) {
        return FGInputEventDecoder.getInputEvent(binaryInput, this.binaryParsers_);
    }

    private static <S, E> E getInputEvent(S s, Collection<IParser<S, ?>> collection) {
        try {
            for (IParser<S, ?> iParser : collection) {
                Object obj = iParser.getInputEvent(s);
                if (obj == null) continue;
                return (E)obj;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static MouseEvent getMouseEvent(int n, int n2, int n3) {
        boolean bl = n == 501 || n == 502 || n == 500 || n == 506;
        int n4 = bl && n != 506 ? 1 : 0;
        int n5 = bl ? 1 : 0;
        MouseEvent mouseEvent = new MouseEvent(dummySourceComponent_, n, 0L, bl ? InputEvent.getMaskForButton(n5) : 0, n2, n3, n2, n3, n4, false, n5);
        return mouseEvent;
    }

    public static class HostEventBinaryParser
    extends AbstractBinaryParser<FGHostStateEvent> {
        public static final String C = "c";
        public static final String S = "s";

        @Override
        protected FGHostStateEvent parseImpl(BinaryInput binaryInput, int n) throws Exception {
            if (n >= 406 && n <= 406) {
                byte[] byArray = binaryInput.getPayload();
                int n2 = binaryInput.getOffset();
                int n3 = byArray[n2 + 1] & 0x7F;
                if ((byArray[n2 + 1] & 0x80) == 128) {
                    n3 += 128;
                }
                int n4 = byArray[n2 + 2] & 0x7F;
                if ((byArray[n2 + 2] & 0x80) == 128) {
                    n4 += 128;
                }
                int n5 = n4 * 256 + n3;
                int n6 = byArray[n2 + 3] & 0x7F;
                if ((byArray[n2 + 3] & 0x80) == 128) {
                    n6 += 128;
                }
                int n7 = byArray[n2 + 4] & 0x7F;
                if ((byArray[n2 + 4] & 0x80) == 128) {
                    n7 += 128;
                }
                char c = (char)(n7 * 256 + n6);
                FGHostStateEvent fGHostStateEvent = FGHostStateEvent.createHostSizeEvent(new Dimension(n5, c));
                return fGHostStateEvent;
            }
            return null;
        }
    }

    public static class ClipboardBinaryParser
    extends AbstractBinaryParser<FGClipboardEvent> {
        @Override
        protected FGClipboardEvent parseImpl(BinaryInput binaryInput, int n) throws Exception {
            if (n >= 403 && n <= 405) {
                if (n == 403) {
                    byte[] byArray = binaryInput.getPayload();
                    int n2 = binaryInput.getOffset();
                    int n3 = byArray[n2 + 1] & 0x7F;
                    if ((byArray[n2 + 1] & 0x80) == 128) {
                        n3 += 128;
                    }
                    int n4 = byArray[n2 + 2] & 0x7F;
                    if ((byArray[n2 + 2] & 0x80) == 128) {
                        n4 += 128;
                    }
                    int n5 = n4 * 256 + n3;
                    byte by = byArray[n2 + 3];
                    if (by == 0) {
                        char[] cArray = new char[n5];
                        for (int i = 0; i < n5; ++i) {
                            cArray[i] = (char)byArray[n2 + 4 + i];
                        }
                        String string = String.valueOf(cArray);
                        System.out.println("-DLTEMP- ClipboardBinaryParser.parseImpl received data = " + string + " lenLo = " + n3 + " lenHi = " + n4 + " len = " + n5);
                        return FGClipboardEvent.createPasteEvent(FGTransferable.createTextTransferable(string));
                    }
                    if (by == 1) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 4, byArray.length - 4);
                        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                        return FGClipboardEvent.createPasteEvent(FGTransferable.createImageTransferable(bufferedImage));
                    }
                    System.out.println("-DLTEMP- ClipboardBinaryParser.parseImpl content type not supported: " + by);
                    return null;
                }
                if (n == 404) {
                    System.out.println("-DLTEMP- ClipboardBinaryParser.parseImpl COPY EVENT");
                    return FGClipboardEvent.createCopyEvent();
                }
                return null;
            }
            return null;
        }
    }

    public static class KeyBinaryParser
    extends AbstractBinaryParser<KeyEvent> {
        private boolean ctrlPressed_ = false;
        private boolean shiftPressed_ = false;
        private boolean altPressed_ = false;
        private boolean escPressed_ = false;

        @Override
        protected KeyEvent parseImpl(BinaryInput binaryInput, int n) throws Exception {
            if (n >= 400 && n <= 402) {
                KeyEvent keyEvent;
                byte[] byArray = binaryInput.getPayload();
                int n2 = binaryInput.getOffset();
                int n3 = byArray[n2 + 1] & 0x7F;
                if ((byArray[n2 + 1] & 0x80) == 128) {
                    n3 += 128;
                }
                int n4 = byArray[n2 + 2] & 0x7F;
                if ((byArray[n2 + 2] & 0x80) == 128) {
                    n4 += 128;
                }
                int n5 = n4 * 256 + n3;
                int n6 = byArray[n2 + 3] & 0x7F;
                if ((byArray[n2 + 3] & 0x80) == 128) {
                    n6 += 128;
                }
                int n7 = byArray[n2 + 4] & 0x7F;
                if ((byArray[n2 + 4] & 0x80) == 128) {
                    n7 += 128;
                }
                char c = (char)(n7 * 256 + n6);
                if (n5 == 13) {
                    n5 = 10;
                    c = '\n';
                } else if (n5 == 46 && c == '\u0000') {
                    n5 = 127;
                    c = '\u007f';
                } else if (n5 == 190) {
                    n5 = 46;
                    c = '.';
                }
                boolean bl = false;
                if (n5 == 17) {
                    bl = true;
                    if (n == 401) {
                        this.ctrlPressed_ = true;
                    }
                    if (n == 402) {
                        this.ctrlPressed_ = false;
                    }
                }
                if (n5 == 16) {
                    bl = true;
                    if (n == 401) {
                        this.shiftPressed_ = true;
                    }
                    if (n == 402) {
                        this.shiftPressed_ = false;
                    }
                }
                if (n5 == 27) {
                    bl = true;
                    if (n == 401) {
                        this.escPressed_ = true;
                    }
                    if (n == 402) {
                        this.escPressed_ = false;
                    }
                }
                int n8 = 0;
                if (this.ctrlPressed_ || this.escPressed_ && n5 == 9) {
                    n8 |= 2;
                }
                if (this.shiftPressed_) {
                    n8 |= 1;
                }
                if (this.altPressed_) {
                    n8 |= 8;
                }
                if (!FGKeyEventParser.isClipboardEvent(keyEvent = new KeyEvent(dummySourceComponent_, n, 0L, bl ? 0 : n8, n == 400 ? 0 : n5, c))) {
                    return keyEvent;
                }
                return null;
            }
            return null;
        }
    }

    public static class MouseBinaryParser
    extends AbstractBinaryParser<MouseEvent> {
        @Override
        protected MouseEvent parseImpl(BinaryInput binaryInput, int n) throws Exception {
            if (n >= 500 && n <= 507) {
                byte[] byArray = binaryInput.getPayload();
                int n2 = binaryInput.getOffset();
                int n3 = byArray[n2 + 1] & 0x7F;
                if ((byArray[n2 + 1] & 0x80) == 128) {
                    n3 += 128;
                }
                n3 += (byArray[n2 + 3] & 0x70) << 4;
                if ((byArray[n2 + 3] & 0x80) == 128) {
                    n3 += 2048;
                }
                int n4 = byArray[n2 + 2] & 0x7F;
                if ((byArray[n2 + 2] & 0x80) == 128) {
                    n4 += 128;
                }
                return FGInputEventDecoder.getMouseEvent(n, n3, n4 += (byArray[n2 + 3] & 0xF) << 8);
            }
            return null;
        }
    }

    public static abstract class AbstractBinaryParser<E>
    implements IParser<BinaryInput, E> {
        @Override
        public E getInputEvent(BinaryInput binaryInput) throws Exception {
            byte[] byArray = binaryInput.getPayload();
            int n = binaryInput.getOffset();
            int n2 = byArray[n] + 400;
            return this.parseImpl(binaryInput, n2);
        }

        protected abstract E parseImpl(BinaryInput var1, int var2) throws Exception;
    }

    public static interface IParser<S, E> {
        public E getInputEvent(S var1) throws Exception;
    }

    public static class BinaryInput {
        private byte[] payload_;
        private int offset_;
        private int len_;

        public BinaryInput(byte[] byArray, int n, int n2) {
            this.payload_ = byArray;
            this.offset_ = n;
            this.len_ = n2;
        }

        public byte[] getPayload() {
            return this.payload_;
        }

        public int getOffset() {
            return this.offset_;
        }

        public int getLen() {
            return this.len_;
        }
    }
}

