/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine;

import flatgui.core.engine.Container;
import flatgui.core.engine.FGExecutorThreadFactory;
import flatgui.core.engine.IResultCollector;
import flatgui.core.engine.InputEventParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AppContainer<ContainerParser extends Container.IContainerParser, ResultCollector extends IResultCollector> {
    private final String containerId_;
    private ContainerParser containerParser_;
    private ResultCollector resultCollector_;
    private Map<Object, Object> containerMap_;
    private Container container_;
    private final InputEventParser reasonParser_;
    private ThreadPoolExecutor evolverExecutorService_;
    private ThreadPoolExecutor notifierExecutorService_;
    private boolean active_ = false;

    public AppContainer(String string, ContainerParser ContainerParser, ResultCollector ResultCollector, Map<Object, Object> map) {
        this.containerId_ = string;
        this.containerParser_ = ContainerParser;
        this.resultCollector_ = ResultCollector;
        this.containerMap_ = map;
        this.reasonParser_ = new InputEventParser();
    }

    public final String getContainerId() {
        return this.containerId_;
    }

    public void initialize() {
        this.evolverExecutorService_ = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new FGExecutorThreadFactory("FlatGUI Evolver ", this.containerId_));
        this.notifierExecutorService_ = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new FGExecutorThreadFactory("FlatGUI Ev.Notifier ", this.containerId_));
        Future<Container> future = this.evolverExecutorService_.submit(() -> new Container(this.containerId_, (Container.IContainerParser)this.containerParser_, (IResultCollector)this.resultCollector_, this.containerMap_, this::submitNotifierTask));
        try {
            this.container_ = future.get();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.active_ = true;
    }

    public void unInitialize() {
        this.active_ = false;
        this.evolverExecutorService_.shutdown();
    }

    public boolean isActive() {
        return this.active_;
    }

    public final Container.IContainerAccessor getContainerAccessor() {
        return this.container_.getContainerAccessor();
    }

    public final Integer getComponentUid(List<Object> list) {
        return this.container_.getComponentUid(list);
    }

    public void evolve(List<Object> list, Object object) {
        this.evolverExecutorService_.submit(() -> this.container_.evolve(list, object));
    }

    public void evolve(Integer n, Object object) {
        this.evolverExecutorService_.submit(() -> this.container_.evolve(n, object));
    }

    public Future<?> evolve(Object object) {
        return this.evolverExecutorService_.submit(() -> this.evolveImpl(object));
    }

    public Object getProperty(List<Object> list, Object object) throws ExecutionException, InterruptedException {
        return this.getContainer().getPropertyValue(list, object);
    }

    protected void evolveImpl(Object object) {
        Map<Object, Object> map;
        try {
            map = this.reasonParser_.parseInputEvent(this.getContainer(), object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            map = Collections.emptyMap();
        }
        try {
            for (Object object2 : map.keySet()) {
                this.container_.evolve((Integer)map.get(object2), object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void evolveImpl(List<Object> list, Object object) {
        this.container_.evolve(list, object);
    }

    protected final ThreadPoolExecutor getEvolverExecutorService() {
        return this.evolverExecutorService_;
    }

    protected final InputEventParser getInputEventParser() {
        return this.reasonParser_;
    }

    protected final Container getContainer() {
        return this.container_;
    }

    protected final ContainerParser getContainerParser() {
        return this.containerParser_;
    }

    protected final ResultCollector getResultCollector() {
        return this.resultCollector_;
    }

    private void submitNotifierTask(Runnable runnable) {
        try {
            this.notifierExecutorService_.submit(runnable).get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

