/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util.resourceserver;

import flatgui.core.awt.FGImageLoader;
import flatgui.core.websocket.IFGCustomServlet;
import flatgui.util.resourceserver.IFGResourceServer;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FGResourceServicePublisher
extends HttpServlet
implements IFGCustomServlet {
    private final IFGResourceServer imageServer_;
    private final FGImageLoader imageLoader_;

    public FGResourceServicePublisher(IFGResourceServer iFGResourceServer) {
        this.imageServer_ = iFGResourceServer;
        this.imageLoader_ = new FGImageLoader();
    }

    @Override
    public void acceptInputEvent(Map<String, String[]> map) {
    }

    protected synchronized void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("image");
        System.out.println("Received request: " + string);
        if (string != null) {
            this.respondImage(httpServletResponse, string);
            return;
        }
    }

    private void respondImage(HttpServletResponse httpServletResponse, String string) throws IOException {
        Image image = this.imageLoader_.getImage(string);
        if (image instanceof RenderedImage) {
            httpServletResponse.setContentType("image/png");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            ImageIO.write((RenderedImage)((Object)image), "png", (OutputStream)servletOutputStream);
            servletOutputStream.flush();
            servletOutputStream.close();
            System.out.println("Served requested image: " + image);
        } else {
            Path path2 = Paths.get(string, new String[0]);
            if (Files.exists(path2, new LinkOption[0])) {
                byte[] byArray = Files.readAllBytes(path2);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.write(byArray);
                servletOutputStream.flush();
                servletOutputStream.close();
                System.out.println("Served requested file: " + string);
            } else {
                System.out.println("Could NOT find requested image: " + string);
            }
        }
    }
}

