/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine.ui;

import flatgui.core.FGClipboardEvent;
import flatgui.core.engine.ui.FGFocusTargetedEventParser;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;

public class FGKeyEventParser
extends FGFocusTargetedEventParser<KeyEvent, Object> {
    @Override
    protected Object reasonToEvent(KeyEvent keyEvent) {
        if (GraphicsEnvironment.isHeadless()) {
            return keyEvent;
        }
        if (FGKeyEventParser.isClipboardPasteEvent(keyEvent)) {
            Clipboard clipboard2 = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard2.getContents(null);
            return FGClipboardEvent.createPasteEvent(transferable);
        }
        if (FGKeyEventParser.isClipboardCopyEvent(keyEvent)) {
            return FGClipboardEvent.createCopyEvent();
        }
        return keyEvent;
    }

    public static boolean isClipboardEvent(KeyEvent keyEvent) {
        return FGKeyEventParser.isClipboardCopyEvent(keyEvent) || FGKeyEventParser.isClipboardPasteEvent(keyEvent);
    }

    public static boolean isClipboardCopyEvent(KeyEvent keyEvent) {
        return keyEvent.getID() != 401 && (keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 155) && (keyEvent.getModifiers() & 2) != 0;
    }

    public static boolean isClipboardPasteEvent(KeyEvent keyEvent) {
        return keyEvent.getID() != 402 && (keyEvent.getKeyCode() == 86 && (keyEvent.getModifiers() & 2) != 0 || keyEvent.getKeyCode() == 155 && (keyEvent.getModifiers() & 1) != 0);
    }
}

