/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine.ui;

import flatgui.core.awt.FGMouseEvent;
import flatgui.core.awt.FGMouseWheelEvent;
import flatgui.core.engine.Container;
import flatgui.core.engine.IInputEventParser;
import flatgui.core.engine.ui.FGClojureContainerParser;
import flatgui.core.engine.ui.FGClojureResultCollector;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FGMouseEventParser
implements IInputEventParser<MouseEvent, MouseEvent> {
    private final int unitSizePx_;
    private double mouseXRel_;
    private double mouseYRel_;
    private boolean leftButtonDown_;
    private Integer pressedComponentId_;
    private MouseEvent lastMouseEvent_;
    private Integer lastComponentId_;

    public FGMouseEventParser(int n) {
        this.unitSizePx_ = n;
    }

    @Override
    public Map<MouseEvent, Integer> parseInputEvent(Container container, MouseEvent mouseEvent) {
        boolean bl = (mouseEvent.getModifiersEx() & 0x400) == 1024;
        double d = this.scaleMouseX(mouseEvent.getX());
        double d2 = this.scaleMouseY(mouseEvent.getY());
        Integer n = this.getTargetComponentUid(0, container, mouseEvent, d, d2);
        if (bl) {
            if (!this.leftButtonDown_) {
                this.pressedComponentId_ = n;
            } else {
                boolean bl2 = true;
                if (bl2) {
                    n = this.pressedComponentId_;
                }
            }
        }
        this.leftButtonDown_ = bl;
        if (n != null) {
            boolean bl3;
            HashMap<MouseEvent, Integer> hashMap = new HashMap<MouseEvent, Integer>();
            boolean bl4 = bl3 = this.lastComponentId_ != null && !this.lastComponentId_.equals(n);
            if (bl3) {
                hashMap.put(FGMouseEventParser.deriveFGEvent(FGMouseEventParser.deriveWithIdAndNoButton(this.lastMouseEvent_, 505), this.mouseXRel_, this.mouseYRel_), this.lastComponentId_);
                hashMap.put(FGMouseEventParser.deriveFGEvent(FGMouseEventParser.deriveWithIdAndNoButton(mouseEvent, 504), this.mouseXRel_, this.mouseYRel_), n);
            }
            hashMap.put(FGMouseEventParser.deriveFGEvent(mouseEvent, this.mouseXRel_, this.mouseYRel_), n);
            this.lastMouseEvent_ = mouseEvent;
            this.lastComponentId_ = n;
            return hashMap;
        }
        return Collections.emptyMap();
    }

    protected double scaleMouseX(double d) {
        return d / (double)this.unitSizePx_;
    }

    protected double scaleMouseY(double d) {
        return d / (double)this.unitSizePx_;
    }

    private static double mxX(List<List<Number>> list) {
        return list.get(0).get(3).doubleValue();
    }

    private static double mxY(List<List<Number>> list) {
        return list.get(1).get(3).doubleValue();
    }

    private Integer getTargetComponentUid(Integer n, Container container, MouseEvent mouseEvent, double d, double d2) {
        Container.IComponent iComponent = container.getComponent(n);
        List<Integer> list = iComponent.getChildIndices();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                boolean bl;
                boolean bl2;
                Integer n2 = list.get(i);
                Container.IComponent iComponent2 = container.getComponent(n2);
                FGClojureContainerParser.FGComponentDataCache fGComponentDataCache = (FGClojureContainerParser.FGComponentDataCache)iComponent2.getCustomData();
                Integer n3 = fGComponentDataCache.getVisibleIndex();
                Object v = container.getPropertyValue(n3);
                boolean bl3 = bl2 = v != null && (!(v instanceof Boolean) || (Boolean)v != false);
                if (!bl2) continue;
                Integer n4 = fGComponentDataCache.getPositionMatrixIndex();
                Integer n5 = fGComponentDataCache.getViewportMatrixIndex();
                Integer n6 = fGComponentDataCache.getClipSizeIndex();
                List list2 = (List)container.getPropertyValue(n4);
                List list3 = (List)container.getPropertyValue(n5);
                List list4 = (List)container.getPropertyValue(n6);
                double d3 = FGMouseEventParser.mxX(list2);
                double d4 = FGMouseEventParser.mxY(list2);
                double d5 = ((Number)((List)list4.get(0)).get(0)).doubleValue();
                double d6 = ((Number)((List)list4.get(1)).get(0)).doubleValue();
                double d7 = d - FGMouseEventParser.mxX(list3);
                double d8 = d2 - FGMouseEventParser.mxY(list3);
                boolean bl4 = ((FGClojureResultCollector)container.getResultCollector()).hasVisiblePopupChildren(n2);
                boolean bl5 = bl = FGMouseEventParser.in(d, d3, d3 + d5) && FGMouseEventParser.in(d2, d4, d4 + d6);
                if (!bl4 && !bl) continue;
                Integer n7 = this.getTargetComponentUid(n2, container, mouseEvent, d7 - d3, d8 - d4);
                if (!(bl4 && !bl ? n7 != null && !n7.equals(n2) : n7 != null)) continue;
                return n7;
            }
        }
        this.setMouseXRel(d);
        this.setMouseYRel(d2);
        return container.isInterestedIn(n, mouseEvent) ? n : null;
    }

    protected final void setMouseXRel(double d) {
        this.mouseXRel_ = d;
    }

    protected final void setMouseYRel(double d) {
        this.mouseYRel_ = d;
    }

    private static boolean in(double d, double d2, double d3) {
        return d >= d2 && d < d3;
    }

    private static MouseEvent deriveWithIdAndNoButton(MouseEvent mouseEvent, int n) {
        return new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), 0, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), 0, false, 0);
    }

    public static MouseEvent deriveFGEvent(MouseEvent mouseEvent, double d, double d2) {
        if (mouseEvent instanceof MouseWheelEvent) {
            return new FGMouseWheelEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation(), ((MouseWheelEvent)mouseEvent).getPreciseWheelRotation(), null, null, d, d2, null);
        }
        return new FGMouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton(), null, null, d, d2, null);
    }
}

