/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core;

import clojure.lang.Keyword;
import flatgui.core.FGComponentPath;
import flatgui.core.IFGInputEventParser;
import flatgui.core.IFGModule;
import flatgui.core.awt.FGMouseEvent;
import flatgui.core.awt.FGMouseTargetComponentInfo;
import flatgui.core.awt.FGMouseWheelEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FGMouseEventParser
implements IFGInputEventParser<MouseEvent> {
    private final int unitSizePx_;
    private boolean leftButtonDown_;
    private FGComponentPath pressedPath_;
    private Object lastTargetIdPath_;
    private Object lastXRelativeVec_;
    private Object lastYRelativeVec_;
    private MouseEvent lastMouseEvent_;

    public FGMouseEventParser(int n) {
        this.unitSizePx_ = n;
    }

    @Override
    public Map<MouseEvent, List<Keyword>> getTargetCellIds(List<Keyword> list, MouseEvent mouseEvent, IFGModule iFGModule) {
        boolean bl = (mouseEvent.getModifiersEx() & 0x400) == 1024;
        double d = (double)mouseEvent.getX() / (double)this.unitSizePx_;
        double d2 = (double)mouseEvent.getY() / (double)this.unitSizePx_;
        FGMouseTargetComponentInfo fGMouseTargetComponentInfo = iFGModule.getMouseTargetInfoAt(d, d2, bl && this.leftButtonDown_ ? this.pressedPath_ : null);
        FGComponentPath fGComponentPath = fGMouseTargetComponentInfo.getComponentPath();
        Object object = fGMouseTargetComponentInfo.getXRelativeVec();
        Object object2 = fGMouseTargetComponentInfo.getYRelativeVec();
        if (bl) {
            if (!this.leftButtonDown_) {
                this.pressedPath_ = fGComponentPath;
            } else if (fGMouseTargetComponentInfo.isCaptureNeeded()) {
                fGComponentPath = this.pressedPath_;
            }
        }
        this.leftButtonDown_ = bl;
        LinkedHashMap<MouseEvent, List<Keyword>> linkedHashMap = new LinkedHashMap<MouseEvent, List<Keyword>>();
        if (fGComponentPath != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.lastTargetIdPath_ != null && !this.lastTargetIdPath_.equals(fGComponentPath.getTargetIdPath());
            if (bl2) {
                linkedHashMap.put(this.deriveFGEvent(this.deriveWithIdAndNoButton(this.lastMouseEvent_, 505), this.lastXRelativeVec_, this.lastYRelativeVec_, (Collection)this.lastTargetIdPath_), (List)this.lastTargetIdPath_);
                linkedHashMap.put(this.deriveFGEvent(this.deriveWithIdAndNoButton(mouseEvent, 504), object, object2, (Collection)fGComponentPath.getTargetIdPath()), (List)fGComponentPath.getTargetIdPath());
            }
            linkedHashMap.put(this.deriveFGEvent(mouseEvent, object, object2, (Collection)fGComponentPath.getTargetIdPath()), (List)fGComponentPath.getTargetIdPath());
            this.lastTargetIdPath_ = fGComponentPath.getTargetIdPath();
            this.lastXRelativeVec_ = object;
            this.lastYRelativeVec_ = object2;
            this.lastMouseEvent_ = mouseEvent;
        }
        return linkedHashMap;
    }

    public static MouseEvent deriveWithCoordAdjustment(MouseEvent mouseEvent, int n, int n2) {
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + n, mouseEvent.getY() + n2, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), 0, false, mouseEvent.getButton());
    }

    public static MouseEvent deriveWithIdAndButton(MouseEvent mouseEvent, int n, int n2) {
        return new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), 0, false, n2);
    }

    void clear() {
        this.pressedPath_ = null;
        this.lastTargetIdPath_ = null;
        this.lastXRelativeVec_ = null;
        this.lastYRelativeVec_ = null;
        this.lastMouseEvent_ = null;
    }

    private MouseEvent deriveWithIdAndNoButton(MouseEvent mouseEvent, int n) {
        return new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), 0, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), 0, false, 0);
    }

    private MouseEvent deriveFGEvent(MouseEvent mouseEvent, Object object, Object object2, Collection<Object> collection) {
        if (mouseEvent instanceof MouseWheelEvent) {
            return new FGMouseWheelEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation(), ((MouseWheelEvent)mouseEvent).getPreciseWheelRotation(), object, object2, null, null, collection);
        }
        return new FGMouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton(), object, object2, null, null, collection);
    }

    Object getLastTargetIdPath() {
        return this.lastTargetIdPath_;
    }
}

