/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine;

import clojure.lang.IFn;
import clojure.lang.IMeta;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGClipboardEvent;
import flatgui.core.FGHostStateEvent;
import flatgui.core.FGTimerEvent;
import flatgui.core.awt.FGMouseEvent;
import flatgui.core.awt.FGMouseWheelEvent;
import flatgui.core.engine.Container;
import flatgui.util.CompactList;
import flatgui.util.ObjectMatrix;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClojureContainerParser
implements Container.IContainerParser {
    private static final Keyword ID_KEY = Keyword.intern((String)"id");
    private static final Keyword CHILDREN_KEY = Keyword.intern((String)"children");
    private static final Keyword EVOLVERS_KEY = Keyword.intern((String)"evolvers");
    private static final Keyword SOURCE_META_KEY = Keyword.intern((String)"source");
    private static final Keyword SYMBOL_META_KEY = Keyword.intern((String)"ns-qualified-sym");
    private static final Keyword INPUT_DEPENDENCIES_META_KEY = Keyword.intern((String)"input-channel-dependencies");
    private static final Keyword RELATIVE_DEPENDENCIES_META_KEY = Keyword.intern((String)"relative-dependencies");
    private static final Keyword THIS_KW = Keyword.intern((String)"this");
    private static final Keyword UP_LEVEL_KW = Keyword.intern((String)"_");
    private static final String FG_NS = "flatgui.core";
    private static final String FG_DEP_NS = "flatgui.dependency";
    private static final Var collectAllEvolverDependencies_ = RT.var((String)"flatgui.core", (String)"collect-all-evolver-dependencies");
    private static final Var compileEvolver_ = RT.var((String)"flatgui.core", (String)"compile-evolver");
    private static final Var getInputDependencies_ = RT.var((String)"flatgui.dependency", (String)"get-input-dependencies");
    private static final Keyword WILDCARD_KEY = Keyword.intern((String)"*");
    private static final Map<Class<?>, Keyword> INPUT_EVENT_KEYS;
    private ObjectMatrix<Object> keys_;

    @Override
    public void setKeyMatrix(ObjectMatrix<Object> objectMatrix) {
        this.keys_ = objectMatrix;
    }

    @Override
    public Object getComponentId(Map<Object, Object> map) {
        return map.get(ClojureContainerParser.getIdKey());
    }

    public static Object getIdKey() {
        return ID_KEY;
    }

    @Override
    public Object getChildOrderPropertyName() {
        return null;
    }

    @Override
    public Object getChildrenPropertyName() {
        return CHILDREN_KEY;
    }

    @Override
    public Collection<Container.SourceNode> processComponent(List<Object> list3, Map<Object, Object> map) {
        Map map2 = (Map)map.get(EVOLVERS_KEY);
        ArrayList<Container.SourceNode> arrayList = new ArrayList<Container.SourceNode>(map.size());
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(map.keySet());
        if (map2 != null) {
            hashSet.addAll(map2.keySet());
        }
        for (Object e : hashSet) {
            CompactList<Object, ObjectMatrix<Object>> compactList = new CompactList<Object, ObjectMatrix<Object>>(this.keys_, list3);
            compactList.add(e);
            boolean bl = map2 != null && map2.get(e) != null;
            Object var10_10 = map2 != null ? map2.get(e) : null;
            List list4 = null;
            Collection<Object> collection = Collections.emptySet();
            Collection<Container.DependencyInfo> collection2 = Collections.emptySet();
            if (bl) {
                IFn iFn = var10_10;
                if (iFn instanceof Var.Unbound) {
                    throw new IllegalStateException("unbound evolver fn: " + list3 + " " + e);
                }
                Map map3 = (Map)((IMeta)iFn).meta();
                if (map3 == null) {
                    throw new IllegalStateException("null meta of evolver fn: " + list3 + " " + e);
                }
                list4 = (List)map3.get(INPUT_DEPENDENCIES_META_KEY);
                collection = (Collection)map3.get(RELATIVE_DEPENDENCIES_META_KEY);
                boolean bl2 = list3.size() == 1;
                collection2 = collection.stream().filter(list -> !bl2 || list.size() > 1).map(list2 -> new Container.DependencyInfo((List<Object>)list2, ClojureContainerParser.buildAbsPath(this.keys_, list3, list2), list2.stream().anyMatch(object -> WILDCARD_KEY.equals(object)))).collect(Collectors.toList());
            }
            arrayList.add(new Container.SourceNode(e, this.getChildrenPropertyName().equals(e), this.getChildOrderPropertyName() != null && this.getChildOrderPropertyName().equals(e), compactList, bl ? collection2 : Collections.emptySet(), bl ? var10_10 : null, bl ? list4 : null));
        }
        return arrayList;
    }

    @Override
    public boolean isInterestedIn(Collection<Object> collection, Class<?> clazz) {
        Keyword keyword = INPUT_EVENT_KEYS.get(clazz);
        return keyword != null ? collection.contains(keyword) : true;
    }

    @Override
    public boolean isWildcardPathElement(Object object) {
        return WILDCARD_KEY.equals(object);
    }

    @Override
    public void processComponentAfterIndexing(Container.IComponent iComponent) {
    }

    static List<Object> buildAbsPath(ObjectMatrix<Object> objectMatrix, List<Object> list, List<Object> list2) {
        try {
            CompactList<Object, ObjectMatrix<Object>> compactList;
            if (list2.isEmpty()) {
                compactList = new CompactList<Object, ObjectMatrix<Object>>(objectMatrix, list);
                compactList.remove(compactList.size() - 1);
            } else if (list2.get(0).equals(THIS_KW)) {
                compactList = new CompactList<Object, ObjectMatrix<Object>>(objectMatrix, list);
                for (int i = 1; i < list2.size(); ++i) {
                    compactList.add(list2.get(i));
                }
            } else if (list2.get(0).equals(UP_LEVEL_KW)) {
                int n;
                int n2;
                for (n2 = 0; n2 < list2.size() && list2.get(n2).equals(UP_LEVEL_KW); ++n2) {
                }
                int n3 = list.size() - n2 - 1;
                compactList = new CompactList(objectMatrix);
                for (n = 0; n < n3; ++n) {
                    compactList.add(list.get(n));
                }
                for (n = n2; n < list2.size(); ++n) {
                    compactList.add(list2.get(n));
                }
            } else {
                compactList = new CompactList<Object, ObjectMatrix<Object>>(objectMatrix, list);
                compactList.remove(compactList.size() - 1);
                for (int i = 0; i < list2.size(); ++i) {
                    compactList.add(list2.get(i));
                }
            }
            return compactList;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Can't build path (path too long) " + list + " + " + list2, exception);
        }
    }

    static {
        HashMap<Class, Keyword> hashMap = new HashMap<Class, Keyword>();
        hashMap.put(MouseEvent.class, Keyword.intern((String)"mouse"));
        hashMap.put(FGMouseEvent.class, Keyword.intern((String)"mouse"));
        hashMap.put(MouseWheelEvent.class, Keyword.intern((String)"mousewheel"));
        hashMap.put(FGMouseWheelEvent.class, Keyword.intern((String)"mousewheel"));
        hashMap.put(KeyEvent.class, Keyword.intern((String)"keyboard"));
        hashMap.put(FGHostStateEvent.class, Keyword.intern((String)"host"));
        hashMap.put(FGClipboardEvent.class, Keyword.intern((String)"clipboard"));
        hashMap.put(FGTimerEvent.class, Keyword.intern((String)"timer"));
        INPUT_EVENT_KEYS = Collections.unmodifiableMap(hashMap);
    }
}

