/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.websocket;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import flatgui.core.FGEvolveInputData;
import flatgui.core.FGLogger;
import flatgui.core.IFGContainer;
import flatgui.core.IFGTemplate;
import flatgui.core.websocket.FGContainerSessionHolder;
import flatgui.core.websocket.FGContainerWebSocket;
import flatgui.core.websocket.FGSessionContainerHost;
import flatgui.core.websocket.IFGCustomServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class FGAppServer {
    public static final String DEFAULT_MAPPING = "/*";
    private static final String API_MAPPING = "/api";
    private static final String API_PARAM_UID = "uid";
    private static final String API_PARAM_SERVICE_NAME = "service";
    private static final String API_PARAM_PATH = "path";
    private static FGLogger logger_ = new FGLogger();
    private final Server server_;
    private final ServletHandler handler_;
    private final Map<String, FGWebSocketServlet> mappingToAppTemplateMap_;
    private final Map<String, TextHtmlServlet> mappingToTextHtmlServletMap_;
    private final Map<String, IFGCustomServlet> mappingToCustomServletMap_;

    public FGAppServer(IFGTemplate iFGTemplate, int n) throws Exception {
        this(iFGTemplate, n, DEFAULT_MAPPING, null);
    }

    public FGAppServer(IFGTemplate iFGTemplate, int n, String string, Consumer<IFGContainer> consumer) throws Exception {
        this.server_ = new Server(n);
        this.handler_ = new ServletHandler();
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameter("allowedOrigins", "*");
        filterHolder.setInitParameter("Access-Control-Allow-Origin", "*");
        filterHolder.setInitParameter("allowedMethods", "GET,POST,HEAD");
        filterHolder.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
        filterHolder.setName("cross-origin");
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setFilterName("cross-origin");
        filterMapping.setPathSpec("*");
        this.handler_.addFilter(filterHolder, filterMapping);
        this.server_.setHandler((Handler)this.handler_);
        this.mappingToAppTemplateMap_ = new HashMap<String, FGWebSocketServlet>();
        this.mappingToTextHtmlServletMap_ = new HashMap<String, TextHtmlServlet>();
        this.mappingToCustomServletMap_ = new HashMap<String, IFGCustomServlet>();
        this.addApplication(string, iFGTemplate, consumer);
        ApiServlet apiServlet = new ApiServlet();
        ServletHolder servletHolder = new ServletHolder((Servlet)apiServlet);
        this.handler_.addServletWithMapping(servletHolder, API_MAPPING);
    }

    public synchronized void addApplication(String string, IFGTemplate iFGTemplate) {
        this.addApplication(string, iFGTemplate, null);
    }

    public synchronized void addApplication(String string, IFGTemplate iFGTemplate, Consumer<IFGContainer> consumer) {
        string = FGAppServer.ensureMapping(string);
        FGWebSocketServlet fGWebSocketServlet = new FGWebSocketServlet(iFGTemplate, consumer);
        ServletHolder servletHolder = new ServletHolder((Servlet)fGWebSocketServlet);
        this.handler_.addServletWithMapping(servletHolder, string);
        this.mappingToAppTemplateMap_.put(string, fGWebSocketServlet);
    }

    public synchronized void setTemplateByMapping(String string, IFGTemplate iFGTemplate, Consumer<IFGContainer> consumer) {
        FGWebSocketServlet fGWebSocketServlet = this.mappingToAppTemplateMap_.get(string = FGAppServer.ensureMapping(string));
        if (fGWebSocketServlet != null) {
            fGWebSocketServlet.setTemplate(iFGTemplate);
            if (consumer != null) {
                fGWebSocketServlet.setContainerConsumer(consumer);
            }
        } else {
            this.addApplication(string, iFGTemplate);
        }
    }

    public synchronized void setTextHtmlServerByMapping(String string, Consumer<OutputStream> consumer) {
        TextHtmlServlet textHtmlServlet = this.mappingToTextHtmlServletMap_.get(string = FGAppServer.ensureMapping(string));
        if (textHtmlServlet == null) {
            textHtmlServlet = new TextHtmlServlet();
            ServletHolder servletHolder = new ServletHolder((Servlet)textHtmlServlet);
            this.handler_.addServletWithMapping(servletHolder, string);
            this.mappingToTextHtmlServletMap_.put(string, textHtmlServlet);
        }
        textHtmlServlet.setWriter(consumer);
    }

    public synchronized void setCustomServlet(String string, IFGCustomServlet iFGCustomServlet) {
        string = FGAppServer.ensureMapping(string);
        this.mappingToCustomServletMap_.put(string, iFGCustomServlet);
        ServletHolder servletHolder = new ServletHolder((Servlet)iFGCustomServlet);
        this.handler_.addServletWithMapping(servletHolder, string);
    }

    public synchronized void setSessionCloseConsumer(String string, BiConsumer<Object, IFGContainer> biConsumer) {
        FGWebSocketServlet fGWebSocketServlet = this.mappingToAppTemplateMap_.get(string = FGAppServer.ensureMapping(string));
        if (fGWebSocketServlet != null) {
            fGWebSocketServlet.setSessionCloseConsumer(biConsumer);
        }
    }

    public void start() throws Exception {
        this.server_.start();
    }

    public void join() throws Exception {
        this.server_.join();
    }

    public Map<String, FGServerAppStats> getAppNameToStatsMap() {
        TreeMap<String, FGServerAppStats> treeMap = new TreeMap<String, FGServerAppStats>();
        for (String string : this.mappingToAppTemplateMap_.keySet()) {
            FGWebSocketServlet fGWebSocketServlet = this.mappingToAppTemplateMap_.get(string);
            HashMap<Object, FGServerAppStats.SessionStats> hashMap = new HashMap<Object, FGServerAppStats.SessionStats>();
            fGWebSocketServlet.getSessionHolder().forEachActiveSession((object, fGContainerSession) -> hashMap.put(object, new FGServerAppStats.SessionStats(fGContainerSession.getAccosiatedWebSocket().getAvgProcessingTime(), fGContainerSession.getAccosiatedWebSocket().getQueueSizeWaiting())));
            treeMap.put(string, new FGServerAppStats(fGWebSocketServlet.getSessionHolder().getActiveOrIdleSessionCount(), fGWebSocketServlet.getSessionHolder().getActiveSessionCount(), hashMap));
        }
        return treeMap;
    }

    static FGLogger getFGLogger() {
        return logger_;
    }

    private static String ensureMapping(String string) {
        if (API_MAPPING.equals(string)) {
            throw new IllegalArgumentException("/api mapping is reserved for internal use.");
        }
        if (string != null && !string.startsWith("/")) {
            string = "/" + string;
        }
        if (string == null) {
            string = DEFAULT_MAPPING;
        }
        return string;
    }

    private class ApiServlet
    extends HttpServlet {
        private ApiServlet() {
        }

        protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            System.out.println("-DLTEMP- ApiServlet.doPost================================ ");
            System.out.println(httpServletRequest.getParameterMap());
            System.out.println("Apps: " + FGAppServer.this.mappingToAppTemplateMap_.keySet());
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>(httpServletRequest.getParameterMap());
            String[] stringArray = (String[])hashMap.get(FGAppServer.API_PARAM_UID);
            if (stringArray == null || stringArray.length != 1) {
                throw new IllegalArgumentException("Param map must contain 'uid' params with single value");
            }
            String string = stringArray[0];
            String[] stringArray2 = (String[])hashMap.get(FGAppServer.API_PARAM_SERVICE_NAME);
            if (stringArray2 == null || stringArray2.length != 1) {
                throw new IllegalArgumentException("Param map must contain 'service' params with single value");
            }
            FGWebSocketServlet fGWebSocketServlet = (FGWebSocketServlet)((Object)FGAppServer.this.mappingToAppTemplateMap_.get("/" + string + "/" + stringArray2[0]));
            if (fGWebSocketServlet != null) {
                String[] stringArray3 = (String[])hashMap.get(FGAppServer.API_PARAM_PATH);
                if (stringArray3 == null || stringArray3.length == 0) {
                    throw new IllegalArgumentException("'path' param with at least one value must be defined in case of passing event to a FlatGUI container");
                }
                hashMap.remove(FGAppServer.API_PARAM_UID);
                hashMap.remove(FGAppServer.API_PARAM_SERVICE_NAME);
                hashMap.remove(FGAppServer.API_PARAM_PATH);
                fGWebSocketServlet.feedEventToAllInstancesAndSendUpdates(this.toTargetIdPath(stringArray3), this.toClojureMap(hashMap));
            } else {
                IFGCustomServlet iFGCustomServlet = (IFGCustomServlet)FGAppServer.this.mappingToCustomServletMap_.get("/" + stringArray2[0]);
                if (iFGCustomServlet != null) {
                    hashMap.remove(FGAppServer.API_PARAM_UID);
                    hashMap.remove(FGAppServer.API_PARAM_SERVICE_NAME);
                    iFGCustomServlet.acceptInputEvent(hashMap);
                } else {
                    throw new IllegalArgumentException("Service '" + stringArray2[0] + "' cannot be identified");
                }
            }
        }

        private IPersistentMap toClojureMap(Map<String, String[]> map) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : map.keySet()) {
                String[] stringArray = map.get(string);
                if (stringArray.length != 1) {
                    throw new IllegalArgumentException("Parameters must have single values in case of passing event to a FlatGUI container");
                }
                hashMap.put(string, stringArray[0]);
            }
            return PersistentHashMap.create(hashMap);
        }

        private List<Keyword> toTargetIdPath(String[] stringArray) {
            ArrayList<Keyword> arrayList = new ArrayList<Keyword>(stringArray.length);
            for (String string : stringArray) {
                arrayList.add(Keyword.intern((String)string));
            }
            return arrayList;
        }
    }

    private static class TextHtmlServlet
    extends HttpServlet {
        private Consumer<OutputStream> writer_;

        private TextHtmlServlet() {
        }

        void setWriter(Consumer<OutputStream> consumer) {
            this.writer_ = consumer;
        }

        protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            httpServletResponse.setContentType("text/html");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            this.writer_.accept((OutputStream)servletOutputStream);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
    }

    private static class FGWebSocketServlet
    extends WebSocketServlet {
        private IFGTemplate template_;
        private final FGContainerSessionHolder sessionHolder_;
        private Consumer<IFGContainer> containerConsumer_;
        private BiConsumer<Object, IFGContainer> sessionCloseConsumer_;

        FGWebSocketServlet(IFGTemplate iFGTemplate, Consumer<IFGContainer> consumer) {
            this.setTemplate(iFGTemplate);
            this.sessionHolder_ = new FGContainerSessionHolder(new FGSessionContainerHost());
            this.setContainerConsumer(consumer);
        }

        public void configure(WebSocketServletFactory webSocketServletFactory) {
            webSocketServletFactory.getPolicy().setIdleTimeout(86400000L);
            webSocketServletFactory.setCreator(this::createWebSocket);
        }

        final void setTemplate(IFGTemplate iFGTemplate) {
            this.template_ = iFGTemplate;
        }

        final void setContainerConsumer(Consumer<IFGContainer> consumer) {
            this.containerConsumer_ = consumer;
        }

        final void setSessionCloseConsumer(BiConsumer<Object, IFGContainer> biConsumer) {
            this.sessionCloseConsumer_ = biConsumer;
        }

        void feedEventToAllInstancesAndSendUpdates(List<Keyword> list, Object object) {
            FGAppServer.getFGLogger().debug("Started feeding event to all(" + this.sessionHolder_.getActiveSessionCount() + " at the moment) active sessions. Event: " + object);
            this.sessionHolder_.forEachActiveSession(fGContainerSession -> {
                FGAppServer.getFGLogger().debug(" session " + fGContainerSession.toString());
                fGContainerSession.getAccosiatedWebSocket().collectAndSendResponse(fGContainerSession.getContainer().feedTargetedEvent(list, new FGEvolveInputData(object, false)), false);
            });
            FGAppServer.getFGLogger().debug("Done feeding event.");
        }

        FGContainerSessionHolder getSessionHolder() {
            return this.sessionHolder_;
        }

        private Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
            return new FGContainerWebSocket(this.template_, this.sessionHolder_, this.containerConsumer_, this.sessionCloseConsumer_);
        }
    }

    public static class FGServerAppStats {
        private long totalSessions_;
        private long activeSessions_;
        private Map<Object, SessionStats> sessionToStat_;

        public FGServerAppStats(long l, long l2, Map<Object, SessionStats> map) {
            this.totalSessions_ = l;
            this.activeSessions_ = l2;
            this.sessionToStat_ = map;
        }

        public long getTotalSessions() {
            return this.totalSessions_;
        }

        public long getActiveSessions() {
            return this.activeSessions_;
        }

        public Map<Object, SessionStats> getSessionToStat() {
            return this.sessionToStat_;
        }

        public String toString() {
            return "total: " + this.totalSessions_ + " active: " + this.activeSessions_;
        }

        public static class SessionStats {
            private double avgProcessingTime_;
            private int queueSizeWaiting_;

            public SessionStats(double d, int n) {
                this.avgProcessingTime_ = d;
                this.queueSizeWaiting_ = n;
            }

            public double getAvgProcessingTime() {
                return this.avgProcessingTime_;
            }

            public int getQueueSizeWaiting() {
                return this.queueSizeWaiting_;
            }
        }
    }
}

