/*
 * Decompiled with CFR 0.152.
 */
package flatgui.controlcenter.view;

import flatgui.controlcenter.IFGStateProvider;
import flatgui.controlcenter.containertree.ContainerPropertyMapTreeNode;
import flatgui.controlcenter.view.IControlCenterPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ContainerTreePanel
implements IControlCenterPanel {
    static final String NAME = "Container";
    private JButton refreshButton_;
    private JTree tree_;
    private IFGStateProvider stateProvider_;

    ContainerTreePanel(IFGStateProvider iFGStateProvider) {
        this.stateProvider_ = iFGStateProvider;
        this.prepare();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JButton[] getToolButtons() {
        return new JButton[]{this.refreshButton_};
    }

    @Override
    public JComponent getContentComponent() {
        return new JScrollPane(this.tree_);
    }

    void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree_.addTreeSelectionListener(treeSelectionListener);
    }

    Map<String, Object> getPropertiesFromSelectedNode() {
        TreePath treePath = this.tree_.getSelectionPath();
        if (treePath != null) {
            return ((ContainerPropertyMapTreeNode)treePath.getLastPathComponent()).getNodeProperties();
        }
        return Collections.EMPTY_MAP;
    }

    private void prepare() {
        this.refreshButton_ = this.createRefreshButton();
        this.tree_ = new JTree();
        this.tree_.getSelectionModel().setSelectionMode(1);
    }

    private JButton createRefreshButton() {
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContainerTreePanel.this.refresh();
            }
        });
        return jButton;
    }

    private void refresh() {
        Object object = this.stateProvider_.getContainer();
        Map map = (Map)object;
        ContainerPropertyMapTreeNode containerPropertyMapTreeNode = new ContainerPropertyMapTreeNode(null, map);
        containerPropertyMapTreeNode.initialize();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(containerPropertyMapTreeNode);
        TreePath treePath = this.tree_.getSelectionPath();
        this.tree_.setModel(defaultTreeModel);
        if (treePath != null) {
            this.tree_.setSelectionPath(treePath);
        }
    }
}

