/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Function;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;

public class TestUtil {
    private static final String TEST = "test";
    private static final String JAVA = "java";
    private static final String DOT = ".";
    private static final String JAVA_EXT = ".java";

    public static int runJavaTests() {
        JUnitCore jUnitCore = new JUnitCore();
        int n = 0;
        try {
            Enumeration<URL> enumeration = ClassLoader.getSystemClassLoader().getResources("");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                String string = uRL.getPath();
                if (!string.contains(TEST)) continue;
                System.out.println("Looking for unit tests in " + string);
                n += TestUtil.listRecursively(new File(uRL.toURI()), file -> TestUtil.runJavaTest(jUnitCore, file));
            }
            return n;
        }
        catch (IOException | URISyntaxException exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    private static int runJavaTest(JUnitCore jUnitCore, File file) {
        int n = 0;
        String string = file.getPath();
        int n2 = string.indexOf(File.separator + JAVA + File.separator);
        if (n2 >= 0) {
            String string2 = string.substring(n2 + File.separator.length() + JAVA.length() + File.separator.length(), string.length() - JAVA_EXT.length());
            string2 = string2.replace(File.separator, DOT);
            System.out.println(" ===== Trying load and run test class " + string2 + " === ");
            try {
                Class<?> clazz = Class.forName(string2);
                if (TestUtil.isRunnableJUnitClass(clazz)) {
                    Result result = jUnitCore.run(new Class[]{clazz});
                    System.out.println(" -- run count: " + result.getRunCount());
                    System.out.println(" -- ignore count: " + result.getIgnoreCount());
                    System.out.println(" -- failure count: " + result.getFailureCount());
                    System.out.println(" -- run time: " + result.getRunTime());
                    if (result.getFailureCount() > 0) {
                        n += result.getFailureCount();
                        result.getFailures().forEach(failure -> {
                            System.out.println(failure.toString());
                            failure.getException().printStackTrace();
                        });
                    }
                } else {
                    System.out.println("Nothing to test: class does not have methods annotated with " + Test.class.getSimpleName());
                }
            }
            catch (Throwable throwable) {
                System.out.println("Failed to run test class " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        return n;
    }

    private static int listRecursively(File file, Function<File, Integer> function) {
        int n = 0;
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    n += TestUtil.listRecursively(file2, function);
                }
            } else {
                n += function.apply(file).intValue();
            }
        }
        return n;
    }

    private static boolean isRunnableJUnitClass(Class<?> clazz) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!method.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        return false;
    }
}

